/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.sql.where;

import cool.scx.sql.AbstractPlaceholderSQL;
import cool.scx.sql.SQLHelper;
import cool.scx.sql.exception.ValidParamListIsEmptyException;
import cool.scx.sql.where.WhereOption;
import cool.scx.sql.where.WhereType;
import cool.scx.tuple.Tuple2;
import cool.scx.tuple.Tuples;
import cool.scx.util.CaseUtils;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

interface WhereTypeHandler {
    public static final WhereTypeHandler IS_NULL_HANDLER;
    public static final WhereTypeHandler IS_NOT_NULL_HANDLER;
    public static final WhereTypeHandler EQUAL_HANDLER;
    public static final WhereTypeHandler NOT_EQUAL_HANDLER;
    public static final WhereTypeHandler LESS_THAN_HANDLER;
    public static final WhereTypeHandler LESS_THAN_OR_EQUAL_HANDLER;
    public static final WhereTypeHandler GREATER_THAN_HANDLER;
    public static final WhereTypeHandler GREATER_THAN_OR_EQUAL_HANDLER;
    public static final WhereTypeHandler LIKE_REGEX_HANDLER;
    public static final WhereTypeHandler NOT_LIKE_REGEX_HANDLER;
    public static final WhereTypeHandler LIKE_HANDLER;
    public static final WhereTypeHandler NOT_LIKE_HANDLER;
    public static final WhereTypeHandler IN_HANDLER;
    public static final WhereTypeHandler NOT_IN_HANDLER;
    public static final WhereTypeHandler BETWEEN_HANDLER;
    public static final WhereTypeHandler NOT_BETWEEN_HANDLER;
    public static final WhereTypeHandler JSON_CONTAINS_HANDLER;

    private static Object[] toArray(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return str.split(",");
        }
        return ObjectUtils.toObjectArray((Object)value);
    }

    private static boolean hasNull(Object[] value) {
        for (Object o : value) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    public Tuple2<Object[], String> getWhereParamsAndWhereClause(String var1, WhereType var2, Object var3, Object var4, WhereOption.Info var5);

    static {
        IS_NOT_NULL_HANDLER = IS_NULL_HANDLER = (name, whereType, value1, value2, info) -> {
            String columnName = SQLHelper.getColumnName(name, info.useJsonExtract(), info.useOriginalName());
            Object[] whereParams = new Object[]{};
            String whereClause = columnName + " " + whereType.keyWord();
            return Tuples.of((Object)whereParams, (Object)whereClause);
        };
        NOT_EQUAL_HANDLER = EQUAL_HANDLER = (name, whereType, value1, value2, info) -> {
            Object[] whereParams;
            Object v1;
            String columnName = SQLHelper.getColumnName(name, info.useJsonExtract(), info.useOriginalName());
            if (value1 instanceof AbstractPlaceholderSQL) {
                AbstractPlaceholderSQL a = (AbstractPlaceholderSQL)value1;
                v1 = "(" + a.normalSQL() + ")";
                whereParams = a.objectArrayParams();
            } else {
                v1 = "?";
                whereParams = new Object[]{value1};
            }
            String whereClause = columnName + " " + whereType.keyWord() + " " + (String)v1;
            return Tuples.of((Object)whereParams, (Object)whereClause);
        };
        LESS_THAN_HANDLER = EQUAL_HANDLER;
        LESS_THAN_OR_EQUAL_HANDLER = EQUAL_HANDLER;
        GREATER_THAN_HANDLER = EQUAL_HANDLER;
        GREATER_THAN_OR_EQUAL_HANDLER = EQUAL_HANDLER;
        LIKE_REGEX_HANDLER = EQUAL_HANDLER;
        NOT_LIKE_REGEX_HANDLER = EQUAL_HANDLER;
        NOT_LIKE_HANDLER = LIKE_HANDLER = (name, whereType, value1, value2, info) -> {
            Object[] whereParams;
            Object v1;
            String columnName = SQLHelper.getColumnName(name, info.useJsonExtract(), info.useOriginalName());
            if (value1 instanceof AbstractPlaceholderSQL) {
                AbstractPlaceholderSQL a = (AbstractPlaceholderSQL)value1;
                v1 = "(" + a.normalSQL() + ")";
                whereParams = a.objectArrayParams();
            } else {
                v1 = "?";
                whereParams = new Object[]{value1};
            }
            String whereClause = columnName + " " + whereType.keyWord() + " CONCAT('%'," + (String)v1 + ",'%')";
            return Tuples.of((Object)whereParams, (Object)whereClause);
        };
        NOT_IN_HANDLER = IN_HANDLER = (name, whereType, value1, value2, info) -> {
            Object[] whereParams;
            String v1;
            String columnName = SQLHelper.getColumnName(name, info.useJsonExtract(), info.useOriginalName());
            if (value1 instanceof AbstractPlaceholderSQL) {
                AbstractPlaceholderSQL a = (AbstractPlaceholderSQL)value1;
                v1 = "(" + a.normalSQL() + ")";
                whereParams = a.objectArrayParams();
            } else {
                whereParams = Arrays.stream(WhereTypeHandler.toArray(value1)).filter(Objects::nonNull).distinct().toArray();
                if (whereParams.length == 0) {
                    throw new ValidParamListIsEmptyException(whereType);
                }
                v1 = "(" + StringUtils.repeat((String)"?", (String)", ", (int)whereParams.length) + ")";
            }
            String whereClause = columnName + " " + whereType.keyWord() + " " + v1;
            return Tuples.of((Object)whereParams, (Object)whereClause);
        };
        NOT_BETWEEN_HANDLER = BETWEEN_HANDLER = (name, whereType, value1, value2, info) -> {
            Object v2;
            Object v1;
            AbstractPlaceholderSQL a;
            String columnName = SQLHelper.getColumnName(name, info.useJsonExtract(), info.useOriginalName());
            ArrayList<Object> whereParams = new ArrayList<Object>();
            if (value1 instanceof AbstractPlaceholderSQL) {
                a = (AbstractPlaceholderSQL)value1;
                v1 = "(" + a.normalSQL() + ")";
                Collections.addAll(whereParams, a.objectArrayParams());
            } else {
                v1 = "?";
                whereParams.add(value1);
            }
            if (value2 instanceof AbstractPlaceholderSQL) {
                a = (AbstractPlaceholderSQL)value2;
                v2 = "(" + a.normalSQL() + ")";
                Collections.addAll(whereParams, a.objectArrayParams());
            } else {
                v2 = "?";
                whereParams.add(value2);
            }
            String whereClause = columnName + " " + whereType.keyWord() + " " + (String)v1 + " AND " + (String)v2;
            return Tuples.of((Object)whereParams.toArray(), (Object)whereClause);
        };
        JSON_CONTAINS_HANDLER = (name, whereType, value1, value2, info) -> {
            Object[] whereParams;
            Object v1;
            String columnName;
            Tuple2<String, String> c = SQLHelper.splitIntoColumnNameAndFieldPath(name);
            String string = columnName = info.useOriginalName() ? (String)c.value0() : CaseUtils.toSnake((String)((String)c.value0()));
            if (StringUtils.isBlank((String)((String)c.value0()))) {
                throw new IllegalArgumentException("\u4f7f\u7528 JSON_CONTAINS \u65f6, \u67e5\u8be2\u540d\u79f0\u4e0d\u5408\u6cd5 !!! \u5b57\u6bb5\u540d : " + name);
            }
            if (value1 instanceof AbstractPlaceholderSQL) {
                AbstractPlaceholderSQL a = (AbstractPlaceholderSQL)value1;
                v1 = "(" + a.normalSQL() + ")";
                whereParams = a.objectArrayParams();
            } else {
                v1 = "?";
                Object[] jsonContainsParams = WhereTypeHandler.toArray(value1);
                whereParams = new Object[]{jsonContainsParams};
            }
            String whereClause = whereType.keyWord() + "(" + columnName;
            whereClause = StringUtils.notBlank((String)((String)c.value1())) ? whereClause + ", " + (String)v1 + ", '$" + (String)c.value1() + "')" : whereClause + ", " + (String)v1 + ")";
            return Tuples.of((Object)whereParams, (Object)whereClause);
        };
    }
}

