/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.sql.where;

import cool.scx.sql.AbstractPlaceholderSQL;
import cool.scx.sql.exception.ValidParamListIsEmptyException;
import cool.scx.sql.exception.WrongWhereTypeParamSizeException;
import cool.scx.sql.where.WhereBody;
import cool.scx.sql.where.WhereOption;
import cool.scx.sql.where.WhereType;
import cool.scx.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public final class Where {
    private final List<WhereBody> whereBodyList = new ArrayList<WhereBody>();
    private final List<Object> whereSQLParams = new ArrayList<Object>();
    private String whereSQL = null;

    public Where add2(String name, WhereType whereType, Object value1, Object value2, WhereOption ... options) {
        return this._add(name, whereType, value1, value2, 2, options);
    }

    public Where add1(String name, WhereType whereType, Object value1, WhereOption ... options) {
        return this._add(name, whereType, value1, null, 1, options);
    }

    public Where add0(String name, WhereType whereType, WhereOption ... options) {
        return this._add(name, whereType, null, null, 0, options);
    }

    public boolean isEmpty() {
        return this.whereBodyList.size() == 0 && this.whereSQL == null;
    }

    public Where isNull(String fieldName, WhereOption ... options) {
        return this.add0(fieldName, WhereType.IS_NULL, options);
    }

    public Where isNotNull(String fieldName, WhereOption ... options) {
        return this.add0(fieldName, WhereType.IS_NOT_NULL, options);
    }

    public Where equal(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.EQUAL, value, options);
    }

    public Where notEqual(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.NOT_EQUAL, value, options);
    }

    public Where greaterThan(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.GREATER_THAN, value, options);
    }

    public Where greaterThanOrEqual(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.GREATER_THAN_OR_EQUAL, value, options);
    }

    public Where lessThan(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.LESS_THAN, value, options);
    }

    public Where lessThanOrEqual(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.LESS_THAN_OR_EQUAL, value, options);
    }

    public Where between(String fieldName, Object value1, Object value2, WhereOption ... options) {
        return this.add2(fieldName, WhereType.BETWEEN, value1, value2, options);
    }

    public Where notBetween(String fieldName, Object value1, Object value2, WhereOption ... options) {
        return this.add2(fieldName, WhereType.NOT_BETWEEN, value1, value2, options);
    }

    public Where likeRegex(String fieldName, String value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.LIKE_REGEX, value, options);
    }

    public Where notLikeRegex(String fieldName, String value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.NOT_LIKE_REGEX, value, options);
    }

    public Where like(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.LIKE, value, options);
    }

    public Where notLike(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.NOT_LIKE, value, options);
    }

    public Where jsonContains(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.JSON_CONTAINS, value, options);
    }

    public Where in(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.IN, value, options);
    }

    public Where notIn(String fieldName, Object value, WhereOption ... options) {
        return this.add1(fieldName, WhereType.NOT_IN, value, options);
    }

    public String[] getWhereClauses() {
        Stream<String> stringStream = this.whereBodyList.stream().map(WhereBody::whereClause);
        if (StringUtils.notBlank((String)this.whereSQL)) {
            stringStream = Stream.concat(stringStream, Stream.of(this.whereSQL));
        }
        return (String[])stringStream.toArray(String[]::new);
    }

    public Object[] getWhereParams() {
        return Stream.concat(this.whereBodyList.stream().flatMap(w -> Arrays.stream(w.whereParams())), this.whereSQLParams.stream()).toArray();
    }

    public String whereSQL() {
        return this.whereSQL;
    }

    public Where whereSQL(Object ... whereSQL) {
        this.clearWhereSQL();
        StringBuilder tempWhereSQL = new StringBuilder();
        for (Object o : whereSQL) {
            if (o instanceof String) {
                String s = (String)o;
                tempWhereSQL.append(s);
                continue;
            }
            if (o instanceof WhereBody) {
                WhereBody w = (WhereBody)o;
                tempWhereSQL.append(w.whereClause());
                this.whereSQLParams.addAll(List.of(w.whereParams()));
                continue;
            }
            if (!(o instanceof AbstractPlaceholderSQL)) continue;
            AbstractPlaceholderSQL a = (AbstractPlaceholderSQL)o;
            tempWhereSQL.append("(").append(a.normalSQL()).append(")");
            this.whereSQLParams.addAll(List.of(a.objectArrayParams()));
        }
        this.whereSQL = tempWhereSQL.toString();
        return this;
    }

    private Where _add(String name, WhereType whereType, Object value1, Object value2, int needParamSize, WhereOption ... options) {
        block6: {
            WhereOption.Info info = new WhereOption.Info(options);
            try {
                WhereBody whereBody = new WhereBody(name, whereType, value1, value2, info);
                if (whereType.paramSize() != needParamSize) {
                    throw new IllegalArgumentException("Where \u53c2\u6570\u9519\u8bef : whereType \u7c7b\u578b : " + whereType + " , \u53c2\u6570\u6570\u91cf\u5fc5\u987b\u4e3a " + whereType.paramSize());
                }
                if (info.replace()) {
                    this.whereBodyList.removeIf(w -> whereBody.name().equals(w.name()));
                }
                this.whereBodyList.add(whereBody);
            }
            catch (WrongWhereTypeParamSizeException e) {
                if (!info.skipIfNull()) {
                    throw e;
                }
            }
            catch (ValidParamListIsEmptyException e) {
                if (info.skipIfEmptyList()) break block6;
                throw e;
            }
        }
        return this;
    }

    public Where remove(String name) {
        this.whereBodyList.removeIf(w -> w.name().equals(name.trim()));
        return this;
    }

    public Where clear() {
        this.whereBodyList.clear();
        return this;
    }

    public Where clearWhereSQL() {
        this.whereSQL = null;
        this.whereSQLParams.clear();
        return this;
    }

    public Where clearAll() {
        this.clear();
        this.clearWhereSQL();
        return this;
    }
}

