/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.sql.handler;

import cool.scx.functional.ScxHandlerARE;
import cool.scx.sql.SQLHelper;
import cool.scx.util.ScanClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BeanListHandler<T>
implements ScxHandlerARE<ResultSet, List<T>, SQLException> {
    private final Constructor<T> tConstructor;
    private final Map<String, Field> nameFieldMap = new HashMap<String, Field>();

    private BeanListHandler(Class<T> type) {
        if (ScanClassUtils.isNormalClass(type)) {
            try {
                this.tConstructor = type.getConstructor(new Class[0]);
                this.tConstructor.newInstance(new Object[0]);
                for (Field field : type.getFields()) {
                    field.setAccessible(true);
                    this.nameFieldMap.put(field.getName(), field);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Class : " + type + " ;\u65e0\u6cd5\u88ab\u5b9e\u4f8b\u5316", e);
            }
        } else {
            throw new IllegalArgumentException("Class : " + type + " ;\u65e0\u6cd5\u88ab\u5b9e\u4f8b\u5316");
        }
    }

    public static <T> BeanListHandler<T> of(Class<T> type) {
        return new BeanListHandler<T>(type);
    }

    public List<T> handle(ResultSet rs) throws SQLException {
        ResultSetMetaData rsm = rs.getMetaData();
        int count = rsm.getColumnCount();
        Field[] allField = new Field[count + 1];
        for (int i = 1; i <= count; ++i) {
            allField[i] = this.nameFieldMap.getOrDefault(rsm.getColumnLabel(i), null);
        }
        ArrayList<T> list = new ArrayList<T>();
        while (rs.next()) {
            T t = this.newInstance();
            for (int i = 1; i <= count; ++i) {
                Class<?> filedType;
                Object o;
                Field field = allField[i];
                if (field == null || (o = SQLHelper.getMySQLType(filedType = field.getType()) != null ? rs.getObject(i, filedType) : (filedType.isEnum() ? SQLHelper.readFromValueOrNull(rs.getString(i), filedType) : SQLHelper.readFromJsonValueOrNull(rs.getString(i), field.getGenericType()))) == null) continue;
                try {
                    field.set(t, o);
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            list.add(t);
        }
        return list;
    }

    private T newInstance() {
        try {
            return this.tConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

