/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.sql;

import cool.scx.functional.ScxHandlerAE;
import cool.scx.functional.ScxHandlerARE;
import cool.scx.functional.ScxHandlerE;
import cool.scx.functional.ScxHandlerRE;
import cool.scx.sql.AbstractPlaceholderSQL;
import cool.scx.sql.UpdateResult;
import cool.scx.util.exception.ScxExceptionHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLRunner {
    static final Logger logger = LoggerFactory.getLogger(SQLRunner.class);
    private static final ExecutorService SQL_RUNNER_EXECUTOR_SERVICE = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private static final ThreadLocal<Connection> CONNECTION_THREAD_LOCAL = new ThreadLocal();
    private final DataSource dataSource;

    public SQLRunner(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        this.dataSource = dataSource;
    }

    public static <T> T query(Connection con, AbstractPlaceholderSQL<?> placeholderSQL, ScxHandlerARE<ResultSet, T, SQLException> resultSetHandler) throws SQLException {
        try (PreparedStatement preparedStatement = placeholderSQL.getPreparedStatement(con);){
            ResultSet resultSet = preparedStatement.executeQuery();
            Object object = resultSetHandler.handle((Object)resultSet);
            return (T)object;
        }
    }

    public static long execute(Connection con, AbstractPlaceholderSQL<?> placeholderSQL) throws SQLException {
        try (PreparedStatement preparedStatement = placeholderSQL.getPreparedStatement(con);){
            preparedStatement.execute();
            long l = preparedStatement.getLargeUpdateCount();
            return l;
        }
    }

    public static UpdateResult update(Connection con, AbstractPlaceholderSQL<?> placeholderSQL) throws SQLException {
        try (PreparedStatement preparedStatement = placeholderSQL.getPreparedStatement(con);){
            long affectedItemsCount = preparedStatement.executeLargeUpdate();
            List<Long> generatedKeys = SQLRunner.getGeneratedKeys(preparedStatement);
            UpdateResult updateResult = new UpdateResult(affectedItemsCount, generatedKeys);
            return updateResult;
        }
    }

    public static UpdateResult updateBatch(Connection con, AbstractPlaceholderSQL<?> placeholderSQL) throws SQLException {
        try (PreparedStatement preparedStatement = placeholderSQL.getPreparedStatement(con);){
            int affectedItemsCount = preparedStatement.executeLargeBatch().length;
            List<Long> generatedKeys = SQLRunner.getGeneratedKeys(preparedStatement);
            UpdateResult updateResult = new UpdateResult(affectedItemsCount, generatedKeys);
            return updateResult;
        }
    }

    public static void autoTransaction(Connection con, ScxHandlerAE<Connection, Exception> handler) throws Exception {
        con.setAutoCommit(false);
        try {
            handler.handle((Object)con);
            con.commit();
        }
        catch (Exception e) {
            con.rollback();
            throw e;
        }
    }

    public static <T> T autoTransaction(Connection con, ScxHandlerARE<Connection, T, Exception> handler) throws Exception {
        con.setAutoCommit(false);
        try {
            Object result = handler.handle((Object)con);
            con.commit();
            return (T)result;
        }
        catch (Exception e) {
            con.rollback();
            throw e;
        }
    }

    private static List<Long> getGeneratedKeys(PreparedStatement preparedStatement) throws SQLException {
        try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
            ArrayList<Long> ids = new ArrayList<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
    }

    public <T> T query(AbstractPlaceholderSQL<?> placeholderSQL, ScxHandlerARE<ResultSet, T, SQLException> resultSetHandler) {
        return (T)ScxExceptionHelper.wrap(() -> {
            Connection connection = CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return SQLRunner.query(connection, placeholderSQL, resultSetHandler);
            }
            try (Connection con = this.getConnection();){
                Object t = SQLRunner.query(con, placeholderSQL, resultSetHandler);
                return t;
            }
        });
    }

    public long execute(AbstractPlaceholderSQL<?> placeholderSQL) {
        return (Long)ScxExceptionHelper.wrap(() -> {
            Connection connection = CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return SQLRunner.execute(connection, placeholderSQL);
            }
            try (Connection con = this.getConnection();){
                Long l = SQLRunner.execute(con, placeholderSQL);
                return l;
            }
        });
    }

    public UpdateResult update(AbstractPlaceholderSQL<?> placeholderSQL) {
        return (UpdateResult)ScxExceptionHelper.wrap(() -> {
            Connection connection = CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return SQLRunner.update(connection, placeholderSQL);
            }
            try (Connection con = this.getConnection();){
                UpdateResult updateResult = SQLRunner.update(con, placeholderSQL);
                return updateResult;
            }
        });
    }

    public UpdateResult updateBatch(AbstractPlaceholderSQL<?> placeholderSQL) {
        return (UpdateResult)ScxExceptionHelper.wrap(() -> {
            Connection connection = CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return SQLRunner.updateBatch(connection, placeholderSQL);
            }
            try (Connection con = this.getConnection();){
                UpdateResult updateResult = SQLRunner.updateBatch(con, placeholderSQL);
                return updateResult;
            }
        });
    }

    public void autoTransaction(ScxHandlerE<?> handler) {
        ScxExceptionHelper.wrap(() -> SQL_RUNNER_EXECUTOR_SERVICE.submit(() -> {
            try (Connection con = this.getConnection(false);){
                CONNECTION_THREAD_LOCAL.set(con);
                try {
                    handler.handle();
                    con.commit();
                    Object var3_3 = null;
                    return var3_3;
                }
                catch (Exception e) {
                    con.rollback();
                    throw e;
                }
                finally {
                    CONNECTION_THREAD_LOCAL.remove();
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }).get());
    }

    public <T> T autoTransaction(ScxHandlerRE<T, ?> handler) {
        return (T)ScxExceptionHelper.wrap(() -> SQL_RUNNER_EXECUTOR_SERVICE.submit(() -> {
            try (Connection con = this.getConnection(false);){
                CONNECTION_THREAD_LOCAL.set(con);
                try {
                    Object result = handler.handle();
                    con.commit();
                    Object object = result;
                    return object;
                }
                catch (Exception e) {
                    con.rollback();
                    throw e;
                }
                finally {
                    CONNECTION_THREAD_LOCAL.remove();
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }).get());
    }

    private Connection getConnection() throws SQLException {
        return this.getConnection(true);
    }

    private Connection getConnection(boolean autoCommit) throws SQLException {
        Connection con = this.dataSource.getConnection();
        con.setAutoCommit(autoCommit);
        return con;
    }
}

