/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.sql;

import com.mysql.cj.BindValue;
import com.mysql.cj.MysqlType;
import com.mysql.cj.NativeQueryBindValue;
import com.mysql.cj.NativeQueryBindings;
import com.mysql.cj.PreparedQuery;
import com.mysql.cj.QueryBindings;
import com.mysql.cj.jdbc.ClientPreparedStatement;
import com.mysql.cj.protocol.a.StringValueEncoder;
import cool.scx.sql.SQLRunner;
import cool.scx.tuple.Tuple2;
import cool.scx.tuple.Tuples;
import cool.scx.util.CaseUtils;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public final class SQLHelper {
    private static final Logger logger = SQLRunner.logger;
    private static final Map<Class<?>, MysqlType> DEFAULT_MYSQL_TYPES = SQLHelper.initDefaultMySQLTypes();

    private static Map<Class<?>, MysqlType> initDefaultMySQLTypes() {
        HashMap tempMap = new HashMap();
        tempMap.put(Byte.TYPE, MysqlType.TINYINT);
        tempMap.put(Byte[].class, MysqlType.BINARY);
        tempMap.put(Double.TYPE, MysqlType.DOUBLE);
        tempMap.put(Float.TYPE, MysqlType.FLOAT);
        tempMap.put(Integer.TYPE, MysqlType.INT);
        tempMap.put(Long.TYPE, MysqlType.BIGINT);
        tempMap.put(Short.TYPE, MysqlType.SMALLINT);
        tempMap.put(Boolean.TYPE, MysqlType.BOOLEAN);
        try {
            Field f = NativeQueryBindings.class.getDeclaredField("DEFAULT_MYSQL_TYPES");
            f.setAccessible(true);
            Map mysqlDriverDefaultMysqlTypes = (Map)f.get(null);
            tempMap.putAll(mysqlDriverDefaultMysqlTypes);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return tempMap;
    }

    public static String getMySQLTypeCreateName(Class<?> javaType) {
        MysqlType mysqlType = SQLHelper.getMySQLType(javaType);
        if (mysqlType == null) {
            mysqlType = javaType.isEnum() ? MysqlType.VARCHAR : MysqlType.JSON;
        }
        return mysqlType == MysqlType.VARCHAR ? mysqlType.getName() + "(128)" : mysqlType.getName();
    }

    public static MysqlType getMySQLType(Class<?> javaType) {
        MysqlType mysqlType = DEFAULT_MYSQL_TYPES.get(javaType);
        if (mysqlType == null) {
            return DEFAULT_MYSQL_TYPES.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(javaType)).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        return mysqlType;
    }

    public static String convertToStringOrNull(Object o) {
        try {
            return (String)ObjectUtils.convertValue((Object)o, String.class);
        }
        catch (Exception e) {
            logger.error("\u5e8f\u5217\u5316\u65f6\u53d1\u751f\u9519\u8bef , \u5df2\u4f7f\u7528 NULL !!!", (Throwable)e);
            return null;
        }
    }

    public static String convertToJsonOrNull(Object o) {
        try {
            return ObjectUtils.toJson((Object)o);
        }
        catch (Exception e) {
            logger.error("\u5e8f\u5217\u5316\u65f6\u53d1\u751f\u9519\u8bef , \u5df2\u4f7f\u7528 NULL !!!", (Throwable)e);
            return null;
        }
    }

    public static Object readFromValueOrNull(String o, Class<?> filedType) {
        if (o != null) {
            try {
                return ObjectUtils.convertValue((Object)o, filedType);
            }
            catch (Exception e) {
                logger.error("\u53cd\u5e8f\u5217\u5316\u65f6\u53d1\u751f\u9519\u8bef , \u5df2\u4f7f\u7528 NULL !!!", (Throwable)e);
            }
        }
        return null;
    }

    public static Object readFromJsonValueOrNull(String json, Type genericType) {
        if (json != null) {
            try {
                return ObjectUtils.jsonMapper().readValue(json, ObjectUtils.constructType((Type)genericType));
            }
            catch (Exception e) {
                logger.error("\u53cd\u5e8f\u5217\u5316\u65f6\u53d1\u751f\u9519\u8bef , \u5df2\u4f7f\u7528 NULL !!!", (Throwable)e);
            }
        }
        return null;
    }

    public static String getColumnName(String name, boolean useJsonExtract, boolean useOriginalName) {
        if (useJsonExtract) {
            Tuple2<String, String> c = SQLHelper.splitIntoColumnNameAndFieldPath(name);
            if (StringUtils.notBlank((String)((String)c.value0())) && StringUtils.notBlank((String)((String)c.value1()))) {
                String jsonQueryColumnName = useOriginalName ? (String)c.value0() : CaseUtils.toSnake((String)((String)c.value0()));
                return jsonQueryColumnName + " -> '$" + (String)c.value1() + "'";
            }
            throw new IllegalArgumentException("\u4f7f\u7528 USE_JSON_EXTRACT \u65f6, \u67e5\u8be2\u540d\u79f0\u4e0d\u5408\u6cd5 !!! \u5b57\u6bb5\u540d : " + name);
        }
        return useOriginalName ? name : CaseUtils.toSnake((String)name);
    }

    public static Tuple2<String, String> splitIntoColumnNameAndFieldPath(String name) {
        char[] charArray = name.toCharArray();
        int index = charArray.length;
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (c != '.' && c != '[') continue;
            index = i;
            break;
        }
        String columnName = name.substring(0, index);
        String fieldPath = name.substring(index);
        return Tuples.of((Object)columnName, (Object)fieldPath);
    }

    public static String getFinalSQL(PreparedStatement preparedStatement) {
        ClientPreparedStatement clientPreparedStatement;
        try {
            clientPreparedStatement = preparedStatement.unwrap(ClientPreparedStatement.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        QueryBindings queryBindings = clientPreparedStatement.getQueryBindings();
        for (BindValue b : queryBindings.getBindValues()) {
            if (!b.isNull()) continue;
            bindValues[i] = new BugFixNullValueNativeQueryBindValue((NativeQueryBindValue)b);
        }
        PreparedQuery preparedQuery = (PreparedQuery)clientPreparedStatement.getQuery();
        String finalSQL = preparedQuery.asSql();
        int batchedArgsSize = preparedQuery.getBatchedArgs() == null ? 0 : preparedQuery.getBatchedArgs().size();
        return batchedArgsSize > 1 ? finalSQL + "... \u989d\u5916\u7684 " + (batchedArgsSize - 1) + " \u9879" : finalSQL;
    }

    public static PreparedStatement logSQL(PreparedStatement p) {
        if (logger.isDebugEnabled()) {
            logger.debug(SQLHelper.getFinalSQL(p));
        }
        return p;
    }

    private static class BugFixNullValueNativeQueryBindValue
    extends NativeQueryBindValue {
        BugFixNullValueNativeQueryBindValue(NativeQueryBindValue copyMe) {
            super(copyMe);
            this.valueEncoder = new StringValueEncoder();
        }
    }
}

