/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.sql;

import cool.scx.sql.AbstractPlaceholderSQL;
import cool.scx.tuple.Tuple2;
import cool.scx.tuple.Tuples;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NamedParameterSQL
extends AbstractPlaceholderSQL<Map<String, Object>> {
    private static final Pattern NAMED_PARAMETER_PATTERN = Pattern.compile(":([\\w.-]+)");
    private final String[] namedParameterNameIndex;

    private NamedParameterSQL(boolean isBatch, String normalSQL, Map<String, Object> params, List<Map<String, Object>> batchParams, String[] namedParameterNameIndex) {
        super(isBatch, normalSQL, params, batchParams);
        this.namedParameterNameIndex = namedParameterNameIndex;
    }

    public static NamedParameterSQL of(String namedParameterSQL, Map<String, Object> params) {
        Tuple2<String, String[]> t = NamedParameterSQL.initNamedParameterNameIndex(namedParameterSQL);
        return new NamedParameterSQL(false, (String)t.value0(), params, null, (String[])t.value1());
    }

    public static NamedParameterSQL ofBatch(String namedParameterSQL, List<Map<String, Object>> batchParams) {
        if (batchParams == null) {
            batchParams = new ArrayList<Map<String, Object>>();
        }
        Tuple2<String, String[]> t = NamedParameterSQL.initNamedParameterNameIndex(namedParameterSQL);
        return new NamedParameterSQL(true, (String)t.value0(), null, batchParams, (String[])t.value1());
    }

    private static Tuple2<String, String[]> initNamedParameterNameIndex(String namedParameterSQL) {
        Matcher matcher = NAMED_PARAMETER_PATTERN.matcher(namedParameterSQL);
        StringBuilder normalSQL = new StringBuilder();
        ArrayList<String> tempNameIndexList = new ArrayList<String>();
        while (matcher.find()) {
            matcher.appendReplacement(normalSQL, "?");
            tempNameIndexList.add(matcher.group(1));
        }
        matcher.appendTail(normalSQL);
        return Tuples.of((Object)normalSQL.toString(), (Object)((String[])tempNameIndexList.toArray(String[]::new)));
    }

    @Override
    public PreparedStatement getPreparedStatementFromSingle(Connection con) throws SQLException {
        PreparedStatement preparedStatement = con.prepareStatement(this.normalSQL, 1);
        if (this.params != null) {
            NamedParameterSQL.fillPreparedStatement(preparedStatement, this.mapToArray((Map)this.params));
        }
        return preparedStatement;
    }

    @Override
    public Object[] objectArrayParams() {
        return this.mapToArray((Map)this.params);
    }

    @Override
    public PreparedStatement getPreparedStatementFromBatch(Connection con) throws SQLException {
        PreparedStatement preparedStatement = con.prepareStatement(this.normalSQL, 1);
        for (Map paramMap : this.batchParams) {
            if (paramMap == null) continue;
            NamedParameterSQL.fillPreparedStatement(preparedStatement, this.mapToArray(paramMap));
            preparedStatement.addBatch();
        }
        return preparedStatement;
    }

    private Object[] mapToArray(Map<String, Object> objectMap) {
        Object[] objectArray = new Object[this.namedParameterNameIndex.length];
        for (int i = 0; i < this.namedParameterNameIndex.length; ++i) {
            objectArray[i] = objectMap.get(this.namedParameterNameIndex[i]);
        }
        return objectArray;
    }
}

