/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.sql;

import com.mysql.cj.MysqlType;
import cool.scx.sql.SQLHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.List;

public abstract class AbstractPlaceholderSQL<T> {
    final boolean isBatch;
    final String normalSQL;
    final T params;
    final List<T> batchParams;

    protected AbstractPlaceholderSQL(boolean isBatch, String normalSQL, T params, List<T> batchParams) {
        this.isBatch = isBatch;
        this.normalSQL = normalSQL;
        this.params = params;
        this.batchParams = batchParams;
    }

    protected static void fillPreparedStatement(PreparedStatement preparedStatement, Object[] params) throws SQLException {
        int index = 1;
        for (Object tempValue : params) {
            if (tempValue != null) {
                Class<?> tempValueClass = tempValue.getClass();
                MysqlType mysqlType = SQLHelper.getMySQLType(tempValueClass);
                if (mysqlType != null) {
                    preparedStatement.setObject(index, tempValue, (SQLType)mysqlType);
                } else if (tempValueClass.isEnum()) {
                    preparedStatement.setString(index, SQLHelper.convertToStringOrNull(tempValue));
                } else {
                    preparedStatement.setString(index, SQLHelper.convertToJsonOrNull(tempValue));
                }
            } else {
                preparedStatement.setNull(index, 0);
            }
            ++index;
        }
    }

    public String normalSQL() {
        return this.normalSQL;
    }

    protected abstract PreparedStatement getPreparedStatementFromBatch(Connection var1) throws SQLException;

    protected abstract PreparedStatement getPreparedStatementFromSingle(Connection var1) throws SQLException;

    public final PreparedStatement getPreparedStatement(Connection con) throws SQLException {
        return SQLHelper.logSQL(this.isBatch ? this.getPreparedStatementFromBatch(con) : this.getPreparedStatementFromSingle(con));
    }

    public abstract Object[] objectArrayParams();
}

