/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging.recorder;

import cool.scx.logging.ScxLogRecord;
import cool.scx.logging.ScxLogRecorder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public class FileRecorder
extends ScxLogRecorder {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final Path storedDirectory;

    public FileRecorder(Path storedDirectory) {
        this.storedDirectory = storedDirectory;
    }

    @Override
    public void record(ScxLogRecord logRecord) {
        Path directory = this.storedDirectory;
        if (directory == null) {
            return;
        }
        String data = this.formatter().format(logRecord);
        String logFileName = this.getLogFileName(logRecord.timeStamp());
        Path path = directory.resolve(logFileName);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)data, StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String name() {
        return "FILE";
    }

    public String getLogFileName(TemporalAccessor temporal) {
        return DATE_TIME_FORMATTER.format(temporal) + ".log";
    }
}

