/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogRecorder;
import cool.scx.logging.ScxLogger;
import cool.scx.logging.ScxLoggerConfig;
import cool.scx.logging.recorder.ConsoleRecorder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class ScxLoggerFactory {
    private static final Map<String, ScxLogger> LOGGER_MAP = new HashMap<String, ScxLogger>();
    private static final ScxLoggerConfig DEFAULT_CONFIG = new ScxLoggerConfig(null).addRecorder(new ConsoleRecorder(), new ScxLogRecorder[0]);
    private static Function<String, ScxLogger> loggerSupplier = ScxLogger::new;

    public static ScxLogger getLogger(String name) {
        return LOGGER_MAP.computeIfAbsent(name, loggerSupplier);
    }

    public static ScxLogger getLogger(Class<?> clazz) {
        return ScxLoggerFactory.getLogger(clazz.getName());
    }

    public static void setLoggerSupplier(Function<String, ScxLogger> newLoggerSupplier) {
        Objects.requireNonNull(newLoggerSupplier, "loggerSupplier \u4e0d\u80fd\u4e3a null");
        loggerSupplier = newLoggerSupplier;
    }

    public static ScxLoggerConfig defaultConfig() {
        return DEFAULT_CONFIG;
    }
}

