/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogger;
import cool.scx.logging.ScxLoggerMessageFormatter;
import cool.scx.logging.ScxLoggingLevel;
import cool.scx.logging.ScxLoggingType;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class ScxLoggerFactory {
    private static final Map<String, ScxLogger> LOGGER_MAP = new HashMap<String, ScxLogger>();
    private static Function<String, ScxLogger> loggerSupplier = ScxLogger::new;
    private static ScxLoggingLevel defaultLevel = ScxLoggingLevel.ERROR;
    private static ScxLoggingType defaultType = ScxLoggingType.CONSOLE;
    private static Path defaultStoredDirectory = null;
    private static boolean defaultStackTrace = false;
    private static ScxLoggerMessageFormatter defaultMessageFormatter = ScxLoggerMessageFormatter.DEFAULT_SCX_LOGGER_MESSAGE_FORMATTER;

    static ScxLoggingLevel defaultLevel() {
        return defaultLevel;
    }

    static ScxLoggingType defaultType() {
        return defaultType;
    }

    static Path defaultStoredDirectory() {
        return defaultStoredDirectory;
    }

    static boolean defaultStackTrace() {
        return defaultStackTrace;
    }

    static ScxLoggerMessageFormatter defaultMessageFormatter() {
        return defaultMessageFormatter;
    }

    public static void setLoggerSupplier(Function<String, ScxLogger> newLoggerSupplier) {
        Objects.requireNonNull(newLoggerSupplier, "loggerSupplier \u4e0d\u80fd\u4e3a null");
        loggerSupplier = newLoggerSupplier;
    }

    public static ScxLogger getLogger(Class<?> clazz) {
        return ScxLoggerFactory.getLogger(clazz.getName());
    }

    public static ScxLogger getLogger(String name) {
        return LOGGER_MAP.computeIfAbsent(name, loggerSupplier);
    }

    public static void setDefaultLevel(ScxLoggingLevel newLevel) {
        Objects.requireNonNull(newLevel, "defaultLevel \u4e0d\u80fd\u4e3a null");
        defaultLevel = newLevel;
    }

    public static void setDefaultType(ScxLoggingType newType) {
        Objects.requireNonNull(newType, "defaultType \u4e0d\u80fd\u4e3a null");
        defaultType = newType;
    }

    public static void setDefaultStoredDirectory(Path newStoredDirectory) {
        defaultStoredDirectory = newStoredDirectory;
    }

    public static void setDefaultStackTrace(boolean newStackTrace) {
        defaultStackTrace = newStackTrace;
    }

    public static void setDefaultMessageFormatter(ScxLoggerMessageFormatter newMessageFormatter) {
        Objects.requireNonNull(newMessageFormatter, "defaultMessageFormatter \u4e0d\u80fd\u4e3a null");
        defaultMessageFormatter = newMessageFormatter;
    }
}

