/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.sqlite;

import cool.scx.jdbc.JDBCType;

public class SQLiteDialectHelper {
    public static JDBCType dialectDataTypeToJDBCType(String dialectDataType) {
        if ("TEXT".equalsIgnoreCase(dialectDataType)) {
            return JDBCType.VARCHAR;
        }
        if ("INTEGER".equalsIgnoreCase(dialectDataType)) {
            return JDBCType.INT;
        }
        throw new IllegalArgumentException("\u672a\u77e5\u65b9\u8a00\u6570\u636e\u7c7b\u578b : " + dialectDataType);
    }

    public static String jdbcTypeToDialectDataType(JDBCType jdbcType) {
        return switch (jdbcType) {
            default -> throw new MatchException(null, null);
            case JDBCType.TINYINT, JDBCType.SMALLINT, JDBCType.INT, JDBCType.BIGINT, JDBCType.BOOLEAN -> "INTEGER";
            case JDBCType.FLOAT, JDBCType.DOUBLE, JDBCType.DECIMAL -> "REAL";
            case JDBCType.DATE, JDBCType.TIME, JDBCType.DATETIME, JDBCType.VARCHAR, JDBCType.TEXT, JDBCType.LONGTEXT, JDBCType.JSON -> "TEXT";
            case JDBCType.BLOB, JDBCType.LONGBLOB -> "BLOB";
        };
    }
}

