/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.static_server;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.LRUCache;
import io.vertx.ext.web.impl.Utils;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SingleFileStaticHandlerImpl
implements Handler<RoutingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleFileStaticHandlerImpl.class);
    private static final Pattern RANGE = Pattern.compile("^bytes=(\\d+)-(\\d*)$");
    private final String singleFile;
    private final String defaultContentEncoding = StandardCharsets.UTF_8.name();
    private final FSTune tune = new FSTune();
    private final Map<String, CacheEntry> cache = new LRUCache(10000);

    public SingleFileStaticHandlerImpl(Path root) {
        this.singleFile = root.toString();
    }

    private void writeCacheHeaders(HttpServerRequest request, FileProps props) {
        MultiMap headers = request.response().headers();
        long maxAgeSeconds = 86400L;
        Utils.addToMapIfAbsent((MultiMap)headers, (CharSequence)HttpHeaders.CACHE_CONTROL, (CharSequence)("public, immutable, max-age=" + maxAgeSeconds));
        Utils.addToMapIfAbsent((MultiMap)headers, (CharSequence)HttpHeaders.LAST_MODIFIED, (CharSequence)Utils.formatRFC1123DateTime((long)props.lastModifiedTime()));
        boolean sendVaryHeader = true;
        if (sendVaryHeader && request.headers().contains(HttpHeaders.ACCEPT_ENCODING)) {
            Utils.addToMapIfAbsent((MultiMap)headers, (CharSequence)HttpHeaders.VARY, (CharSequence)"accept-encoding");
        }
        headers.set("date", Utils.formatRFC1123DateTime((long)System.currentTimeMillis()));
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        if (request.method() != HttpMethod.GET && request.method() != HttpMethod.HEAD) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Not GET or HEAD so ignoring request");
            }
            context.next();
        } else {
            String uriDecodedPath;
            if (!request.isEnded()) {
                request.pause();
            }
            if ((uriDecodedPath = URIDecoder.decodeURIComponent((String)context.normalizedPath(), (boolean)false)) == null) {
                LOG.warn((Object)("Invalid path: " + context.request().path()));
                context.next();
                return;
            }
            FileSystem fs = context.vertx().fileSystem();
            this.sendStatic(context, fs);
        }
    }

    private void sendStatic(RoutingContext context, FileSystem fileSystem) {
        String path = "single-file";
        CacheEntry entry = this.cache.get(path);
        if (entry != null && !entry.isOutOfDate()) {
            if (entry.isMissing()) {
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.next();
                return;
            }
            long lastModified = Utils.secondsFactor((long)entry.props.lastModifiedTime());
            if (Utils.fresh((RoutingContext)context, (long)lastModified)) {
                context.response().setStatusCode(HttpResponseStatus.NOT_MODIFIED.code()).end();
                return;
            }
        }
        boolean dirty = entry != null;
        String localFile = this.singleFile;
        fileSystem.exists(localFile, exists -> {
            if (exists.failed()) {
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.fail(exists.cause());
                return;
            }
            if (!((Boolean)exists.result()).booleanValue()) {
                this.cache.put(path, null);
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.next();
                return;
            }
            this.getFileProps(fileSystem, localFile, (Handler<AsyncResult<FileProps>>)((Handler)res -> {
                if (res.succeeded()) {
                    FileProps fprops = (FileProps)res.result();
                    if (fprops == null) {
                        if (dirty) {
                            this.cache.remove(path);
                        }
                        if (!context.request().isEnded()) {
                            context.request().resume();
                        }
                        context.next();
                    } else if (fprops.isRegularFile()) {
                        CacheEntry now = new CacheEntry(fprops, 30000L);
                        this.cache.put(path, now);
                        if (Utils.fresh((RoutingContext)context, (long)Utils.secondsFactor((long)fprops.lastModifiedTime()))) {
                            context.response().setStatusCode(HttpResponseStatus.NOT_MODIFIED.code()).end();
                            return;
                        }
                        this.sendFile(context, localFile, fprops);
                    }
                } else {
                    if (!context.request().isEnded()) {
                        context.request().resume();
                    }
                    context.fail(res.cause());
                }
            }));
        });
    }

    private void getFileProps(FileSystem fileSystem, String file, Handler<AsyncResult<FileProps>> resultHandler) {
        if (this.tune.useAsyncFS()) {
            fileSystem.props(file, resultHandler);
        } else {
            try {
                boolean tuneEnabled = this.tune.enabled();
                long start = tuneEnabled ? System.nanoTime() : 0L;
                FileProps props = fileSystem.propsBlocking(file);
                if (tuneEnabled) {
                    this.tune.update(start, System.nanoTime());
                }
                resultHandler.handle((Object)Future.succeededFuture((Object)props));
            }
            catch (RuntimeException e) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)e.getCause()));
            }
        }
    }

    private void sendFile(RoutingContext context, String file, FileProps fileProps) {
        Matcher m;
        HttpServerRequest request = context.request();
        HttpServerResponse response = context.response();
        Long offset = null;
        Long end = null;
        MultiMap headers = null;
        if (response.closed()) {
            return;
        }
        String range = request.getHeader("Range");
        end = fileProps.size() - 1L;
        if (range != null && (m = RANGE.matcher(range)).matches()) {
            try {
                String part = m.group(1);
                offset = Long.parseLong(part);
                if (offset < 0L || offset >= fileProps.size()) {
                    throw new IndexOutOfBoundsException();
                }
                part = m.group(2);
                if (part != null && part.length() > 0 && (end = Long.valueOf(Math.min(end, Long.parseLong(part)))) < offset) {
                    throw new IndexOutOfBoundsException();
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                context.response().putHeader(HttpHeaders.CONTENT_RANGE, (CharSequence)("bytes */" + fileProps.size()));
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.fail(HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE.code());
                return;
            }
        }
        headers = response.headers();
        headers.set(HttpHeaders.ACCEPT_RANGES, (CharSequence)"bytes");
        headers.set(HttpHeaders.CONTENT_LENGTH, (CharSequence)Long.toString(end + 1L - (offset == null ? 0L : offset)));
        this.writeCacheHeaders(request, fileProps);
        if (request.method() == HttpMethod.HEAD) {
            response.end();
        } else if (offset != null) {
            headers.set(HttpHeaders.CONTENT_RANGE, (CharSequence)("bytes " + offset + "-" + end + "/" + fileProps.size()));
            response.setStatusCode(HttpResponseStatus.PARTIAL_CONTENT.code());
            long finalOffset = offset;
            long finalLength = end + 1L - offset;
            String contentType = MimeMapping.getMimeTypeForFilename((String)file);
            if (contentType != null) {
                if (contentType.startsWith("text")) {
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + this.defaultContentEncoding));
                } else {
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                }
            }
            response.sendFile(file, finalOffset, finalLength, res2 -> {
                if (res2.failed()) {
                    if (!context.request().isEnded()) {
                        context.request().resume();
                    }
                    context.fail(res2.cause());
                }
            });
        } else {
            String extension = this.getFileExtension(file);
            String contentType = MimeMapping.getMimeTypeForExtension((String)extension);
            if (contentType != null) {
                if (contentType.startsWith("text")) {
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + this.defaultContentEncoding));
                } else {
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
                }
            }
            response.sendFile(file, res2 -> {
                if (res2.failed()) {
                    if (!context.request().isEnded()) {
                        context.request().resume();
                    }
                    context.fail(res2.cause());
                }
            });
        }
    }

    private String getFileExtension(String file) {
        int li = file.lastIndexOf(46);
        if (li != -1 && li != file.length() - 1) {
            return file.substring(li + 1);
        }
        return null;
    }

    private static class FSTune {
        private static final int NUM_SERVES_TUNING_FS_ACCESS = 1000;
        private volatile boolean enabled = true;
        private volatile boolean useAsyncFS;
        private long totalTime;
        private long numServesBlocking;
        private long nextAvgCheck = 1000L;

        private FSTune() {
        }

        boolean enabled() {
            return this.enabled;
        }

        boolean useAsyncFS() {
            return this.useAsyncFS;
        }

        synchronized void update(long start, long end) {
            long dur = end - start;
            this.totalTime += dur;
            ++this.numServesBlocking;
            if (this.numServesBlocking == Long.MAX_VALUE) {
                this.reset();
            } else if (this.numServesBlocking == this.nextAvgCheck) {
                double avg = (double)this.totalTime / (double)this.numServesBlocking;
                long maxAvgServeTimeNanoSeconds = 1000000L;
                if (avg > (double)maxAvgServeTimeNanoSeconds) {
                    this.useAsyncFS = true;
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Switching to async file system access in static file server as fs access is slow! (Average access time of " + avg + " ns)"));
                    }
                    this.enabled = false;
                }
                this.nextAvgCheck += 1000L;
            }
        }

        synchronized void reset() {
            this.nextAvgCheck = 1000L;
            this.totalTime = 0L;
            this.numServesBlocking = 0L;
        }
    }

    private static final class CacheEntry {
        final long createDate = System.currentTimeMillis();
        final FileProps props;
        final long cacheEntryTimeout;

        private CacheEntry(FileProps props, long cacheEntryTimeout) {
            this.props = props;
            this.cacheEntryTimeout = cacheEntryTimeout;
        }

        boolean isOutOfDate() {
            return System.currentTimeMillis() - this.createDate > this.cacheEntryTimeout;
        }

        public boolean isMissing() {
            return this.props == null;
        }
    }
}

