/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.sqlite;

import cool.scx.data.jdbc.dialect.Dialect;
import cool.scx.data.jdbc.mapping.Column;
import cool.scx.data.jdbc.sqlite.type_handler.SQLiteLocalDateTimeTypeHandler;
import cool.scx.data.jdbc.type_handler.TypeHandler;
import cool.scx.util.StringUtils;
import java.lang.reflect.Field;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.sqlite.JDBC;
import org.sqlite.SQLiteDataSource;
import org.sqlite.core.CorePreparedStatement;
import org.sqlite.core.CoreStatement;
import org.sqlite.jdbc4.JDBC4PreparedStatement;

public class SQLiteDialect
extends Dialect {
    public static final System.Logger logger = System.getLogger(SQLiteDialect.class.getName());
    static final Field CoreStatement_sql;
    static final Field CoreStatement_batch;
    static final Field CorePreparedStatement_batchQueryCount;

    public SQLiteDialect() {
        this.typeHandlerSelector.registerTypeHandler(LocalDateTime.class, (TypeHandler)new SQLiteLocalDateTimeTypeHandler());
    }

    private static String getFinalSQL0(String sql, Object[] batch) {
        StringBuilder sb = new StringBuilder();
        int currentParameter = 0;
        for (int pos = 0; pos < sql.length(); ++pos) {
            char character = sql.charAt(pos);
            if (character == '?' && currentParameter <= batch.length) {
                Object value = batch[currentParameter];
                sb.append(value != null ? value.toString() : "NULL");
                ++currentParameter;
                continue;
            }
            sb.append(character);
        }
        return sb.toString();
    }

    public boolean canHandle(String url) {
        return StringUtils.startsWithIgnoreCase((String)url, (String)"jdbc:sqlite:");
    }

    public boolean canHandle(DataSource dataSource) {
        try {
            return dataSource instanceof SQLiteDataSource || dataSource.isWrapperFor(SQLiteDataSource.class);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean canHandle(Driver driver) {
        return driver instanceof JDBC;
    }

    public String getFinalSQL(Statement statement) {
        int batchQueryCount;
        Object[] batch;
        String sql;
        CorePreparedStatement corePreparedStatement;
        try {
            corePreparedStatement = (CorePreparedStatement)statement.unwrap(JDBC4PreparedStatement.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        try {
            sql = (String)CoreStatement_sql.get(corePreparedStatement);
            batch = (Object[])CoreStatement_batch.get(corePreparedStatement);
            batchQueryCount = (Integer)CorePreparedStatement_batchQueryCount.get(corePreparedStatement);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        String finalSQL = SQLiteDialect.getFinalSQL0(sql, batch);
        return batchQueryCount > 1 ? finalSQL + "... \u989d\u5916\u7684 " + (batchQueryCount - 1) + " \u9879" : finalSQL;
    }

    public String getLimitSQL(String sql, Long offset, Long limit) {
        String limitClauses = limit == null ? "" : (offset == null || offset == 0L ? " LIMIT " + limit : " LIMIT " + offset + "," + limit);
        return sql + limitClauses;
    }

    public DataSource createDataSource(String url, String username, String password, String[] parameters) {
        SQLiteDataSource sqLiteDataSource = new SQLiteDataSource();
        sqLiteDataSource.setUrl(url);
        return sqLiteDataSource;
    }

    public String getDataTypeDefinitionByClass(Class<?> javaType) {
        if (javaType == Integer.class || javaType == Long.class) {
            return "INTEGER";
        }
        if (javaType == String.class) {
            return "TEXT";
        }
        return "BLOB";
    }

    public List<String> getColumnConstraint(Column column) {
        ArrayList<String> list = new ArrayList<String>();
        if (column.primaryKey() && column.autoIncrement()) {
            list.add("PRIMARY KEY AUTOINCREMENT");
        }
        list.add(column.notNull() || column.primaryKey() ? "NOT NULL" : "NULL");
        if (column.unique()) {
            list.add("UNIQUE");
        }
        if (StringUtils.notBlank((String)column.defaultValue())) {
            list.add("DEFAULT " + column.defaultValue());
        }
        return list;
    }

    static {
        try {
            CoreStatement_sql = CoreStatement.class.getDeclaredField("sql");
            CoreStatement_batch = CoreStatement.class.getDeclaredField("batch");
            CorePreparedStatement_batchQueryCount = CorePreparedStatement.class.getDeclaredField("batchQueryCount");
            CoreStatement_sql.setAccessible(true);
            CoreStatement_batch.setAccessible(true);
            CorePreparedStatement_batchQueryCount.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

