/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.spy.wrapper;

import cool.scx.data.jdbc.spy.SpyEventListener;
import cool.scx.data.jdbc.spy.wrapper.AbstractWrapper;
import cool.scx.util.ArrayUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class StatementWrapper
extends AbstractWrapper
implements Statement {
    protected final SpyEventListener eventListener;
    private final Statement statement;

    protected StatementWrapper(Statement delegate, SpyEventListener eventListener) {
        super(delegate);
        this.statement = delegate;
        this.eventListener = eventListener;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            ResultSet resultSet = this.statement.getResultSet();
            return resultSet;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterGetResultSet(this.statement, System.nanoTime() - start, e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecuteQuery(this.statement, sql);
            ResultSet resultSet = this.statement.executeQuery(sql);
            return resultSet;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteQuery(this.statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int[] updateCounts = null;
        try {
            this.eventListener.onBeforeExecuteBatch(this.statement);
            int[] nArray = updateCounts = this.statement.executeBatch();
            return nArray;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteBatch(this.statement, System.nanoTime() - start, ArrayUtils.toLongArray((int[])updateCounts), e);
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long[] updateCounts = null;
        try {
            this.eventListener.onBeforeExecuteBatch(this.statement);
            long[] lArray = updateCounts = this.statement.executeLargeBatch();
            return lArray;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteBatch(this.statement, System.nanoTime() - start, updateCounts, e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statement, sql);
            boolean bl = this.statement.execute(sql);
            return bl;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute(this.statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statement, sql);
            boolean bl = this.statement.execute(sql, autoGeneratedKeys);
            return bl;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute(this.statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statement, sql);
            boolean bl = this.statement.execute(sql, columnIndexes);
            return bl;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute(this.statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statement, sql);
            boolean bl = this.statement.execute(sql, columnNames);
            return bl;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute(this.statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statement, sql);
            int n = rowCount = this.statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statement, sql);
            int n = rowCount = this.statement.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statement, sql);
            int n = rowCount = this.statement.executeUpdate(sql, columnIndexes);
            return n;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statement, sql);
            int n = rowCount = this.statement.executeUpdate(sql, columnNames);
            return n;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0L;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statement, sql);
            long l = rowCount = this.statement.executeLargeUpdate(sql);
            return l;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0L;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statement, sql);
            long l = rowCount = this.statement.executeLargeUpdate(sql, autoGeneratedKeys);
            return l;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0L;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statement, sql);
            long l = rowCount = this.statement.executeLargeUpdate(sql, columnIndexes);
            return l;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0L;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statement, sql);
            long l = rowCount = this.statement.executeLargeUpdate(sql, columnNames);
            return l;
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statement, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeAddBatch(this.statement, sql);
            this.statement.addBatch(sql);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterAddBatch(this.statement, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public void close() throws SQLException {
        SQLException e = null;
        try {
            this.statement.close();
        }
        catch (SQLException sqle) {
            e = sqle;
            throw e;
        }
        finally {
            this.eventListener.onAfterStatementClose(this.statement, e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.statement.setCursorName(name);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.statement.setFetchDirection(direction);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.statement.setFetchSize(rows);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.statement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.statement.setPoolable(poolable);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.statement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.statement.isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.statement.getLargeUpdateCount();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.statement.getLargeMaxRows();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.statement.setLargeMaxRows(max);
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        return this.statement.enquoteLiteral(val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        return this.statement.enquoteIdentifier(identifier, alwaysQuote);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return this.statement.isSimpleIdentifier(identifier);
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return this.statement.enquoteNCharLiteral(val);
    }
}

