/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.mysql;

import com.mysql.cj.MysqlType;
import com.mysql.cj.NativeQueryBindings;
import com.mysql.cj.PreparedQuery;
import com.mysql.cj.conf.RuntimeProperty;
import com.mysql.cj.jdbc.ClientPreparedStatement;
import com.mysql.cj.jdbc.MysqlDataSource;
import cool.scx.data.jdbc.dialect.Dialect;
import cool.scx.data.jdbc.mapping.Column;
import cool.scx.data.jdbc.mapping.Table;
import cool.scx.util.StringUtils;
import java.lang.reflect.Field;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class MySQLDialect
extends Dialect {
    private static final Map<Class<?>, MysqlType> DEFAULT_MYSQL_TYPES = new HashMap();

    private static SQLType getSQLType(Class<?> javaType) {
        MysqlType mysqlType = DEFAULT_MYSQL_TYPES.get(javaType);
        if (mysqlType == null) {
            return DEFAULT_MYSQL_TYPES.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(javaType)).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        return mysqlType;
    }

    public boolean canHandle(String url) {
        return StringUtils.startsWithIgnoreCase((String)url, (String)"jdbc:mysql:");
    }

    public boolean canHandle(DataSource dataSource) {
        try {
            return dataSource instanceof MysqlDataSource || dataSource.isWrapperFor(MysqlDataSource.class);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean canHandle(Driver driver) {
        return driver instanceof com.mysql.cj.jdbc.Driver;
    }

    public String getFinalSQL(Statement preparedStatement) {
        ClientPreparedStatement clientPreparedStatement;
        try {
            clientPreparedStatement = preparedStatement.unwrap(ClientPreparedStatement.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        PreparedQuery preparedQuery = (PreparedQuery)clientPreparedStatement.getQuery();
        String finalSQL = preparedQuery.asSql();
        int batchedArgsSize = preparedQuery.getBatchedArgs() == null ? 0 : preparedQuery.getBatchedArgs().size();
        return batchedArgsSize > 1 ? finalSQL + "... \u989d\u5916\u7684 " + (batchedArgsSize - 1) + " \u9879" : finalSQL;
    }

    public String getLimitSQL(String sql, Long offset, Long limit) {
        String limitClauses = limit == null ? "" : (offset == null || offset == 0L ? " LIMIT " + limit : " LIMIT " + offset + "," + limit);
        return sql + limitClauses;
    }

    public DataSource createDataSource(String url, String username, String password, String[] parameters) {
        MysqlDataSource mysqlDataSource = new MysqlDataSource();
        mysqlDataSource.setUrl(url);
        mysqlDataSource.setUser(username);
        mysqlDataSource.setPassword(password);
        for (String parameter : parameters) {
            String[] p = parameter.split("=");
            if (p.length != 2) continue;
            RuntimeProperty property = mysqlDataSource.getProperty(p[0]);
            property.setValue(property.getPropertyDefinition().parseObject(p[1], null));
        }
        return mysqlDataSource;
    }

    public List<String> getColumnConstraint(Column column) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(column.notNull() || column.primaryKey() ? "NOT NULL" : "NULL");
        if (column.autoIncrement()) {
            list.add("AUTO_INCREMENT");
        }
        if (StringUtils.notBlank((String)column.defaultValue())) {
            list.add("DEFAULT " + column.defaultValue());
        }
        if (StringUtils.notBlank((String)column.onUpdateValue())) {
            list.add("ON UPDATE " + column.onUpdateValue());
        }
        return list;
    }

    public String getDataTypeDefinitionByClass(Class<?> javaType) {
        SQLType mysqlType = MySQLDialect.getSQLType(javaType);
        if (mysqlType == null) {
            mysqlType = javaType.isEnum() ? MysqlType.VARCHAR : MysqlType.JSON;
        }
        return mysqlType == MysqlType.VARCHAR ? mysqlType.getName() + "(128)" : mysqlType.getName();
    }

    public List<String> getTableConstraint(Table<?> table) {
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : table.columns()) {
            String name = column.name();
            if (column.primaryKey()) {
                list.add("PRIMARY KEY (`" + name + "`)");
            }
            if (column.unique()) {
                list.add("UNIQUE KEY `unique_" + name + "`(`" + name + "`)");
            }
            if (!column.index()) continue;
            list.add("KEY `index_" + name + "`(`" + name + "`)");
        }
        return list;
    }

    public String defaultDateType() {
        return "VARCHAR(128)";
    }

    public PreparedStatement beforeExecuteQuery(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setFetchSize(Integer.MIN_VALUE);
        return preparedStatement;
    }

    static {
        DEFAULT_MYSQL_TYPES.put(Byte.TYPE, MysqlType.TINYINT);
        DEFAULT_MYSQL_TYPES.put(Byte[].class, MysqlType.BINARY);
        DEFAULT_MYSQL_TYPES.put(Double.TYPE, MysqlType.DOUBLE);
        DEFAULT_MYSQL_TYPES.put(Float.TYPE, MysqlType.FLOAT);
        DEFAULT_MYSQL_TYPES.put(Integer.TYPE, MysqlType.INT);
        DEFAULT_MYSQL_TYPES.put(Long.TYPE, MysqlType.BIGINT);
        DEFAULT_MYSQL_TYPES.put(Short.TYPE, MysqlType.SMALLINT);
        DEFAULT_MYSQL_TYPES.put(Boolean.TYPE, MysqlType.BOOLEAN);
        try {
            Field f = NativeQueryBindings.class.getDeclaredField("DEFAULT_MYSQL_TYPES");
            f.setAccessible(true);
            Map mysqlDriverDefaultMysqlTypes = (Map)f.get(null);
            DEFAULT_MYSQL_TYPES.putAll(mysqlDriverDefaultMysqlTypes);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

