/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.meta_data;

import cool.scx.data.jdbc.mapping.Table;
import cool.scx.data.jdbc.meta_data.ColumnMetaData;
import cool.scx.data.jdbc.meta_data.IndexMetaData;
import cool.scx.data.jdbc.meta_data.KeyMetaData;
import cool.scx.data.jdbc.meta_data.MetaDataHelper;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;

public final class TableMetaData
implements Table<ColumnMetaData> {
    private final String catalog;
    private final String schema;
    private final String name;
    private final String remarks;
    private ColumnMetaData[] columns;
    private Map<String, ColumnMetaData> columnsMap = new HashMap<String, ColumnMetaData>();
    private KeyMetaData[] keys;
    private IndexMetaData[] indexes;

    public TableMetaData(String catalog, String schema, String name, String remarks) {
        this.catalog = catalog;
        this.schema = schema;
        this.name = name;
        this.remarks = remarks;
    }

    public String catalog() {
        return this.catalog;
    }

    public String schema() {
        return this.schema;
    }

    public String name() {
        return this.name;
    }

    public String remarks() {
        return this.remarks;
    }

    public ColumnMetaData[] columns() {
        return this.columns;
    }

    public TableMetaData refreshColumns(Connection connection) {
        this.keys = MetaDataHelper.initPrimaryKeys(connection, this.catalog, this.schema, this.name);
        this.indexes = MetaDataHelper.initIndexInfo(connection, this.catalog, this.schema, this.name, false, false);
        this.columns = MetaDataHelper.initColumns(connection, this.catalog, this.schema, this.name, null, this);
        this.columnsMap = MetaDataHelper.toColumnsMap(this.columns);
        return this;
    }

    public KeyMetaData[] keys() {
        return this.keys;
    }

    public IndexMetaData[] indexes() {
        return this.indexes;
    }

    public ColumnMetaData getColumn(String column) {
        return this.columnsMap.get(column);
    }
}

