/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.meta_data;

import cool.scx.data.jdbc.JDBCContext;
import cool.scx.data.jdbc.dialect.Dialect;
import cool.scx.data.jdbc.dialect.DialectSelector;
import cool.scx.data.jdbc.mapping.Column;
import cool.scx.data.jdbc.mapping.Table;
import cool.scx.data.jdbc.meta_data.MetaDataHelper;
import cool.scx.data.jdbc.meta_data.TableMetaData;
import cool.scx.data.jdbc.sql.SQL;
import cool.scx.data.jdbc.sql.SQLRunner;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public final class SchemaHelper {
    public static String getMigrateSQL(Table<?> oldTable, Table<?> newTable, Dialect dialect) {
        return "";
    }

    public static SchemaVerifyResult verify(Table<?> oldTable, Table<?> newTable) {
        Column column;
        ArrayList<Column> needAdd = new ArrayList<Column>();
        ArrayList<Column> needRemove = new ArrayList<Column>();
        ArrayList<Column> needChange = new ArrayList<Column>();
        for (Column oldColumn : oldTable.columns()) {
            column = newTable.getColumn(oldColumn.name());
            if (column != null) continue;
            needRemove.add(oldColumn);
        }
        for (Column newColumn : newTable.columns()) {
            column = oldTable.getColumn(newColumn.name());
            if (column != null) continue;
            needAdd.add(newColumn);
        }
        return new SchemaVerifyResult((Column[])needAdd.toArray(Column[]::new), needRemove, needChange);
    }

    public static void fixTable(Table<?> tableInfo, JDBCContext jdbcContext) throws SQLException {
        DataSource dataSource = jdbcContext.dataSource();
        SQLRunner sqlRunner = jdbcContext.sqlRunner();
        try (Connection con = dataSource.getConnection();){
            String catalog = con.getCatalog();
            String schema = con.getSchema();
            Map<String, TableMetaData> map = MetaDataHelper.toTablesMap(MetaDataHelper.initTables(con, catalog, schema, tableInfo.name(), null));
            TableMetaData tableMetaData = map.get(tableInfo.name());
            if (tableMetaData == null) {
                String createTableDDL = DialectSelector.findDialect((DataSource)dataSource).getCreateTableDDL(tableInfo);
                sqlRunner.execute(con, SQL.ofNormal((String)createTableDDL));
            } else {
                SchemaVerifyResult verify = SchemaHelper.verify(tableMetaData.refreshColumns(con), tableInfo);
                Column[] needAdd = verify.needAdd();
                if (needAdd.length > 0) {
                    String alertTableDDL = DialectSelector.findDialect((DataSource)dataSource).getAlertTableDDL(needAdd, tableInfo);
                    sqlRunner.execute(con, SQL.ofNormal((String)alertTableDDL));
                }
            }
        }
    }

    public static boolean checkNeedFixTable(Table<?> tableInfo, DataSource dataSource) throws SQLException {
        try (Connection con = dataSource.getConnection();){
            String catalog = con.getCatalog();
            String schema = con.getSchema();
            Map<String, TableMetaData> map = MetaDataHelper.toTablesMap(MetaDataHelper.initTables(con, catalog, schema, tableInfo.name(), null));
            TableMetaData tableMetaData = map.get(tableInfo.name());
            if (tableMetaData == null) {
                boolean bl = true;
                return bl;
            }
            SchemaVerifyResult verify = SchemaHelper.verify(tableMetaData.refreshColumns(con), tableInfo);
            Column[] needAdd = verify.needAdd();
            if (needAdd.length > 0) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public record SchemaVerifyResult(Column[] needAdd, List<Column> needRemove, List<Column> needChange) {
    }
}

