/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;

public final class ConstructorUtils {
    public static <T> Constructor<T> findNoArgsConstructor(Class<T> type) {
        Constructor<?> noArgsConstructor = null;
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            noArgsConstructor = constructor;
            break;
        }
        if (noArgsConstructor == null) {
            throw new IllegalArgumentException("\u5bfb\u627e \u65e0\u53c2 \u6784\u9020\u51fd\u6570\u5931\u8d25, type " + type.getName());
        }
        return noArgsConstructor;
    }

    public static <T> Constructor<T> findRecordConstructor(Class<T> type) {
        Constructor<?> canonicalConstructor = null;
        RecordComponent[] recordComponents = type.getRecordComponents();
        Object[] recordComponentTypes = Arrays.stream(recordComponents).map(RecordComponent::getType).toArray();
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            boolean matched = Arrays.equals(recordComponentTypes, constructor.getParameterTypes());
            if (!matched) continue;
            canonicalConstructor = constructor;
            break;
        }
        if (canonicalConstructor == null) {
            throw new IllegalArgumentException("\u5bfb\u627e Record \u89c4\u8303\u6784\u9020\u51fd\u6570\u5931\u8d25, type " + type.getName());
        }
        return canonicalConstructor;
    }
}

