/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import cool.scx.util.JacksonHelper;
import cool.scx.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ObjectUtils {
    public static final TypeReference<Map<String, Object>> MAP_TYPE = new TypeReference<Map<String, Object>>(){};
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final JsonMapper JSON_MAPPER = (JsonMapper)JacksonHelper.initObjectMapper(JsonMapper.builder());
    private static final XmlMapper XML_MAPPER = (XmlMapper)JacksonHelper.initObjectMapper(XmlMapper.builder());
    private static final JsonMapper JSON_MAPPER_IGNORE_JSON_IGNORE = JacksonHelper.setIgnoreJsonIgnore((JsonMapper)JacksonHelper.initObjectMapper(JsonMapper.builder()));
    private static final XmlMapper XML_MAPPER_IGNORE_JSON_IGNORE = JacksonHelper.setIgnoreJsonIgnore((XmlMapper)JacksonHelper.initObjectMapper(XmlMapper.builder()));
    private static final JsonMapper JSON_MAPPER_IGNORE_NULL_VALUE = JacksonHelper.setIgnoreNullValue((JsonMapper)JacksonHelper.initObjectMapper(JsonMapper.builder()));
    private static final XmlMapper XML_MAPPER_IGNORE_NULL_VALUE = JacksonHelper.setIgnoreNullValue((XmlMapper)JacksonHelper.initObjectMapper(XmlMapper.builder()));
    private static final JsonMapper JSON_MAPPER_IGNORE_NULL_VALUE_AND_IGNORE_JSON_IGNORE = JacksonHelper.setIgnoreJsonIgnore(JacksonHelper.setIgnoreNullValue((JsonMapper)JacksonHelper.initObjectMapper(JsonMapper.builder())));
    private static final XmlMapper XML_MAPPER_IGNORE_NULL_VALUE_AND_IGNORE_JSON_IGNORE = JacksonHelper.setIgnoreJsonIgnore(JacksonHelper.setIgnoreNullValue((XmlMapper)JacksonHelper.initObjectMapper(XmlMapper.builder())));

    public static JsonMapper jsonMapper(Option ... options) {
        Option.Info info = new Option.Info(options);
        if (info.ignoreJsonIgnore && !info.ignoreNullValue) {
            return JSON_MAPPER_IGNORE_JSON_IGNORE;
        }
        if (info.ignoreJsonIgnore) {
            return JSON_MAPPER_IGNORE_NULL_VALUE_AND_IGNORE_JSON_IGNORE;
        }
        if (info.ignoreNullValue) {
            return JSON_MAPPER_IGNORE_NULL_VALUE;
        }
        return JSON_MAPPER;
    }

    public static XmlMapper xmlMapper(Option ... options) {
        Option.Info info = new Option.Info(options);
        if (info.ignoreJsonIgnore && !info.ignoreNullValue) {
            return XML_MAPPER_IGNORE_JSON_IGNORE;
        }
        if (info.ignoreJsonIgnore) {
            return XML_MAPPER_IGNORE_NULL_VALUE_AND_IGNORE_JSON_IGNORE;
        }
        if (info.ignoreNullValue) {
            return XML_MAPPER_IGNORE_NULL_VALUE;
        }
        return XML_MAPPER;
    }

    public static JavaType constructType(Type type) {
        return JSON_MAPPER.getTypeFactory().constructType(type);
    }

    public static JavaType constructType(TypeReference<?> typeRef) {
        return ObjectUtils.constructType(typeRef.getType());
    }

    public static <T> T convertValue(Object fromValue, JavaType javaType, Option ... options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, javaType);
    }

    public static <T> T convertValue(Object fromValue, Class<T> tClass, Option ... options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, ObjectUtils.constructType(tClass));
    }

    public static <T> T convertValue(Object fromValue, Type toValueType, Option ... options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, ObjectUtils.constructType(toValueType));
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef, Option ... options) {
        return (T)ObjectUtils.jsonMapper(options).convertValue(fromValue, ObjectUtils.constructType(toValueTypeRef));
    }

    public static String toJson(Object value, String defaultValue, Option ... options) {
        try {
            return ObjectUtils.toJson(value, options);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String toXml(Object value, String defaultValue, Option ... options) {
        try {
            return ObjectUtils.toXml(value, options);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String toJson(Object value, Option ... options) throws JsonProcessingException {
        return ObjectUtils.jsonMapper(options).writeValueAsString(value);
    }

    public static String toXml(Object value, Option ... options) throws JsonProcessingException {
        return ObjectUtils.xmlMapper(options).writeValueAsString(value);
    }

    public static Object[] toObjectArray(Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (source instanceof Collection) {
            return ((Collection)source).toArray();
        }
        if (source.getClass().isArray()) {
            int length = Array.getLength(source);
            Object[] arr = new Object[length];
            if (source instanceof byte[]) {
                byte[] arrSource = (byte[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof short[]) {
                short[] arrSource = (short[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof int[]) {
                int[] arrSource = (int[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof long[]) {
                long[] arrSource = (long[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof float[]) {
                float[] arrSource = (float[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = Float.valueOf(arrSource[i]);
                }
            } else if (source instanceof double[]) {
                double[] arrSource = (double[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof boolean[]) {
                boolean[] arrSource = (boolean[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = arrSource[i];
                }
            } else if (source instanceof char[]) {
                char[] arrSource = (char[])source;
                for (int i = 0; i < length; ++i) {
                    arr[i] = Character.valueOf(arrSource[i]);
                }
            }
            return arr;
        }
        throw new IllegalArgumentException("\u6e90\u6570\u636e\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6570\u7ec4\u5bf9\u8c61 !!!");
    }

    private static Map<String, Object> flatMap0(Map<?, ?> sourceMap, String parentKey) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Object prefix = StringUtils.isBlank(parentKey) ? "" : parentKey + ".";
        sourceMap.forEach((arg_0, arg_1) -> ObjectUtils.lambda$flatMap0$0((String)prefix, result, arg_0, arg_1));
        return result;
    }

    public static Map<String, Object> flatMap(Map<?, ?> sourceMap) {
        return ObjectUtils.flatMap0(sourceMap, null);
    }

    private static /* synthetic */ void lambda$flatMap0$0(String prefix, LinkedHashMap result, Object key, Object value) {
        String newKey = prefix + key;
        if (value instanceof Map) {
            Map m = (Map)value;
            result.putAll(ObjectUtils.flatMap0(m, newKey));
        } else {
            result.put(newKey, value);
        }
    }

    public static enum Option {
        IGNORE_NULL_VALUE,
        IGNORE_JSON_IGNORE;


        private static class Info {
            boolean ignoreNullValue = false;
            boolean ignoreJsonIgnore = false;

            Info(Option ... options) {
                block4: for (Option option : options) {
                    switch (option) {
                        case IGNORE_NULL_VALUE: {
                            this.ignoreNullValue = true;
                            continue block4;
                        }
                        case IGNORE_JSON_IGNORE: {
                            this.ignoreJsonIgnore = true;
                        }
                    }
                }
            }
        }
    }
}

