/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.util.providers;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import com.vladmihalcea.hibernate.type.util.providers.DataSourceProvider;
import com.vladmihalcea.hibernate.type.util.providers.Database;
import java.util.Properties;
import javax.sql.DataSource;

public class MySQLDataSourceProvider
implements DataSourceProvider {
    private boolean rewriteBatchedStatements = true;
    private boolean cachePrepStmts = false;
    private boolean useServerPrepStmts = false;
    private boolean useTimezone = false;
    private boolean useJDBCCompliantTimezoneShift = false;
    private boolean useLegacyDatetimeCode = true;

    public boolean isRewriteBatchedStatements() {
        return this.rewriteBatchedStatements;
    }

    public void setRewriteBatchedStatements(boolean rewriteBatchedStatements) {
        this.rewriteBatchedStatements = rewriteBatchedStatements;
    }

    public boolean isCachePrepStmts() {
        return this.cachePrepStmts;
    }

    public void setCachePrepStmts(boolean cachePrepStmts) {
        this.cachePrepStmts = cachePrepStmts;
    }

    public boolean isUseServerPrepStmts() {
        return this.useServerPrepStmts;
    }

    public void setUseServerPrepStmts(boolean useServerPrepStmts) {
        this.useServerPrepStmts = useServerPrepStmts;
    }

    public boolean isUseTimezone() {
        return this.useTimezone;
    }

    public void setUseTimezone(boolean useTimezone) {
        this.useTimezone = useTimezone;
    }

    public boolean isUseJDBCCompliantTimezoneShift() {
        return this.useJDBCCompliantTimezoneShift;
    }

    public void setUseJDBCCompliantTimezoneShift(boolean useJDBCCompliantTimezoneShift) {
        this.useJDBCCompliantTimezoneShift = useJDBCCompliantTimezoneShift;
    }

    public boolean isUseLegacyDatetimeCode() {
        return this.useLegacyDatetimeCode;
    }

    public void setUseLegacyDatetimeCode(boolean useLegacyDatetimeCode) {
        this.useLegacyDatetimeCode = useLegacyDatetimeCode;
    }

    @Override
    public String hibernateDialect() {
        return "org.hibernate.dialect.MySQLDialect";
    }

    @Override
    public DataSource dataSource() {
        MysqlDataSource dataSource = new MysqlDataSource();
        dataSource.setURL("jdbc:mysql://localhost/high_performance_java_persistence?rewriteBatchedStatements=" + this.rewriteBatchedStatements + "&cachePrepStmts=" + this.cachePrepStmts + "&useServerPrepStmts=" + this.useServerPrepStmts + "&useTimezone=" + this.useTimezone + "&useJDBCCompliantTimezoneShift=" + this.useJDBCCompliantTimezoneShift + "&useLegacyDatetimeCode=" + this.useLegacyDatetimeCode);
        dataSource.setUser("mysql");
        dataSource.setPassword("admin");
        return dataSource;
    }

    @Override
    public Class<? extends DataSource> dataSourceClassName() {
        return MysqlDataSource.class;
    }

    @Override
    public Properties dataSourceProperties() {
        Properties properties = new Properties();
        properties.setProperty("url", this.url());
        return properties;
    }

    @Override
    public String url() {
        return "jdbc:mysql://localhost/high_performance_java_persistence?user=mysql&password=admin";
    }

    @Override
    public String username() {
        return null;
    }

    @Override
    public String password() {
        return null;
    }

    @Override
    public Database database() {
        return Database.MYSQL;
    }

    public String toString() {
        return "MySQLDataSourceProvider{rewriteBatchedStatements=" + this.rewriteBatchedStatements + ", cachePrepStmts=" + this.cachePrepStmts + ", useServerPrepStmts=" + this.useServerPrepStmts + ", useTimezone=" + this.useTimezone + ", useJDBCCompliantTimezoneShift=" + this.useJDBCCompliantTimezoneShift + ", useLegacyDatetimeCode=" + this.useLegacyDatetimeCode + '}';
    }
}

