/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    public static final String GETTER_PREFIX = "get";
    public static final String SETTER_PREFIX = "set";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);

    private ReflectionUtils() {
        throw new UnsupportedOperationException("ReflectionUtils is not instantiable!");
    }

    public static <T> T newInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw ReflectionUtils.handleException(className, e);
        }
        catch (InstantiationException e) {
            throw ReflectionUtils.handleException(className, e);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(className, e);
        }
    }

    public static <T> T getFieldValue(Object target, String fieldName) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object returnValue = field.get(target);
            return (T)returnValue;
        }
        catch (NoSuchFieldException e) {
            throw ReflectionUtils.handleException(fieldName, e);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(fieldName, e);
        }
    }

    public static void setFieldValue(Object target, String fieldName, Object value) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (NoSuchFieldException e) {
            throw ReflectionUtils.handleException(fieldName, e);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(fieldName, e);
        }
    }

    public static Method getMethod(Object target, String methodName, Class ... parameterTypes) {
        try {
            return target.getClass().getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw ReflectionUtils.handleException(methodName, e);
        }
    }

    public static boolean hasMethod(Class<?> targetClass, String methodName, Class ... parameterTypes) {
        try {
            targetClass.getMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static Method getSetter(Object target, String property, Class<?> parameterType) {
        String setterMethodName = SETTER_PREFIX + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method setter = ReflectionUtils.getMethod(target, setterMethodName, parameterType);
        setter.setAccessible(true);
        return setter;
    }

    public static Method getGetter(Object target, String property) {
        String getterMethodName = GETTER_PREFIX + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method getter = ReflectionUtils.getMethod(target, getterMethodName, new Class[0]);
        getter.setAccessible(true);
        return getter;
    }

    public static <T> T invoke(Object target, Method method, Object ... parameters) {
        try {
            method.setAccessible(true);
            Object returnValue = method.invoke(target, parameters);
            return (T)returnValue;
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(method.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(method.getName(), e);
        }
    }

    public static <T> T invokeGetter(Object target, String property) {
        Method setter = ReflectionUtils.getGetter(target, property);
        try {
            return (T)setter.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(setter.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(setter.getName(), e);
        }
    }

    public static void invokeSetter(Object target, String property, Object parameter) {
        Method setter = ReflectionUtils.getSetter(target, property, parameter.getClass());
        try {
            setter.invoke(target, parameter);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(setter.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(setter.getName(), e);
        }
    }

    public static void invokeSetter(Object target, String property, boolean parameter) {
        Method setter = ReflectionUtils.getSetter(target, property, Boolean.TYPE);
        try {
            setter.invoke(target, parameter);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(setter.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(setter.getName(), e);
        }
    }

    public static void invokeSetter(Object target, String property, int parameter) {
        Method setter = ReflectionUtils.getSetter(target, property, Integer.TYPE);
        try {
            setter.invoke(target, parameter);
        }
        catch (IllegalAccessException e) {
            throw ReflectionUtils.handleException(setter.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleException(setter.getName(), e);
        }
    }

    private static IllegalArgumentException handleException(String fieldName, NoSuchFieldException e) {
        LOGGER.error("Couldn't find field " + fieldName, (Throwable)e);
        return new IllegalArgumentException(e);
    }

    private static IllegalArgumentException handleException(String methodName, NoSuchMethodException e) {
        LOGGER.error("Couldn't find method " + methodName, (Throwable)e);
        return new IllegalArgumentException(e);
    }

    private static IllegalArgumentException handleException(String memberName, IllegalAccessException e) {
        LOGGER.error("Couldn't access member " + memberName, (Throwable)e);
        return new IllegalArgumentException(e);
    }

    private static IllegalArgumentException handleException(String methodName, InvocationTargetException e) {
        LOGGER.error("Couldn't invoke method " + methodName, (Throwable)e);
        return new IllegalArgumentException(e);
    }

    private static IllegalArgumentException handleException(String className, ClassNotFoundException e) {
        LOGGER.error("Couldn't find class " + className, (Throwable)e);
        return new IllegalArgumentException(e);
    }

    private static IllegalArgumentException handleException(String className, InstantiationException e) {
        LOGGER.error("Couldn't instantiate class " + className, (Throwable)e);
        return new IllegalArgumentException(e);
    }
}

