/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.util;

import com.vladmihalcea.hibernate.type.util.DataSourceProxyType;
import com.vladmihalcea.hibernate.type.util.PersistenceUnitInfoImpl;
import com.vladmihalcea.hibernate.type.util.providers.DataSourceProvider;
import com.vladmihalcea.hibernate.type.util.providers.HSQLDBDataSourceProvider;
import com.vladmihalcea.hibernate.type.util.transaction.ConnectionCallable;
import com.vladmihalcea.hibernate.type.util.transaction.ConnectionVoidCallable;
import com.vladmihalcea.hibernate.type.util.transaction.HibernateTransactionConsumer;
import com.vladmihalcea.hibernate.type.util.transaction.HibernateTransactionFunction;
import com.vladmihalcea.hibernate.type.util.transaction.JPATransactionFunction;
import com.vladmihalcea.hibernate.type.util.transaction.JPATransactionVoidFunction;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.transaction.spi.LocalStatus;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.jdbc.Work;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.metamodel.spi.TypeContributions;
import org.hibernate.metamodel.spi.TypeContributor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTest {
    protected final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread bob = new Thread(r);
            bob.setName("Bob");
            return bob;
        }
    });
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private EntityManagerFactory emf;
    private SessionFactory sf;
    private List<Closeable> closeables = new ArrayList<Closeable>();

    @Before
    public void init() {
        if (this.nativeHibernateSessionFactoryBootstrap()) {
            this.sf = this.newSessionFactory();
        } else {
            this.emf = this.newEntityManagerFactory();
        }
    }

    @After
    public void destroy() {
        if (this.nativeHibernateSessionFactoryBootstrap()) {
            this.sf.close();
        } else {
            this.emf.close();
        }
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.LOGGER.error("Failure", (Throwable)e);
            }
        }
        this.closeables.clear();
    }

    public EntityManagerFactory entityManagerFactory() {
        return this.nativeHibernateSessionFactoryBootstrap() ? null : this.emf;
    }

    public SessionFactory sessionFactory() {
        return this.nativeHibernateSessionFactoryBootstrap() ? this.sf : (SessionFactory)this.entityManagerFactory().unwrap(SessionFactory.class);
    }

    protected boolean nativeHibernateSessionFactoryBootstrap() {
        return false;
    }

    protected abstract Class<?>[] entities();

    protected List<String> entityClassNames() {
        ArrayList<String> classNames = new ArrayList<String>();
        for (Class<?> entityClass : this.entities()) {
            classNames.add(entityClass.getName());
        }
        return classNames;
    }

    protected String[] packages() {
        return null;
    }

    protected String[] resources() {
        return null;
    }

    protected Interceptor interceptor() {
        return null;
    }

    private SessionFactory newSessionFactory() {
        List<Type> additionalTypes;
        Interceptor interceptor;
        String[] resources;
        Properties properties = this.properties();
        Configuration configuration = new Configuration().addProperties(properties);
        for (Class<?> entityClass : this.entities()) {
            configuration.addAnnotatedClass(entityClass);
        }
        String[] packages = this.packages();
        if (packages != null) {
            for (String scannedPackage : packages) {
                configuration.addPackage(scannedPackage);
            }
        }
        if ((resources = this.resources()) != null) {
            for (String resource : resources) {
                configuration.addResource(resource);
            }
        }
        if ((interceptor = this.interceptor()) != null) {
            configuration.setInterceptor(interceptor);
        }
        if ((additionalTypes = this.additionalTypes()) != null) {
            configuration.registerTypeContributor(new TypeContributor(){

                public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
                    for (Type type : additionalTypes) {
                        if (type instanceof BasicType) {
                            typeContributions.contributeType((BasicType)type);
                            continue;
                        }
                        if (type instanceof UserType) {
                            typeContributions.contributeType((UserType)type, new String[]{type.getName()});
                            continue;
                        }
                        if (!(type instanceof CompositeUserType)) continue;
                        typeContributions.contributeType((CompositeUserType)type, new String[]{type.getName()});
                    }
                }
            });
        }
        return configuration.buildSessionFactory((ServiceRegistry)new StandardServiceRegistryBuilder().applySettings((Map)properties).build());
    }

    protected EntityManagerFactory newEntityManagerFactory() {
        PersistenceUnitInfoImpl persistenceUnitInfo = this.persistenceUnitInfo(this.getClass().getSimpleName());
        HashMap configuration = new HashMap();
        EntityManagerFactoryBuilderImpl entityManagerFactoryBuilder = new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor((PersistenceUnitInfo)persistenceUnitInfo), configuration);
        return entityManagerFactoryBuilder.build();
    }

    protected Integrator integrator() {
        return null;
    }

    protected PersistenceUnitInfoImpl persistenceUnitInfo(String name) {
        PersistenceUnitInfoImpl persistenceUnitInfo = new PersistenceUnitInfoImpl(name, this.entityClassNames(), this.properties());
        String[] resources = this.resources();
        if (resources != null) {
            persistenceUnitInfo.getMappingFileNames().addAll(Arrays.asList(resources));
        }
        return persistenceUnitInfo;
    }

    protected Properties properties() {
        Properties properties = new Properties();
        properties.put("hibernate.dialect", this.dataSourceProvider().hibernateDialect());
        properties.put("hibernate.hbm2ddl.auto", "create-drop");
        DataSource dataSource = this.newDataSource();
        if (dataSource != null) {
            properties.put("hibernate.connection.datasource", dataSource);
        }
        properties.put("hibernate.generate_statistics", Boolean.TRUE.toString());
        this.additionalProperties(properties);
        return properties;
    }

    protected void additionalProperties(Properties properties) {
    }

    protected DataSourceProxyType dataSourceProxyType() {
        return DataSourceProxyType.DATA_SOURCE_PROXY;
    }

    protected DataSource newDataSource() {
        DataSource dataSource = this.proxyDataSource() ? this.dataSourceProxyType().dataSource(this.dataSourceProvider().dataSource()) : this.dataSourceProvider().dataSource();
        return dataSource;
    }

    protected boolean proxyDataSource() {
        return true;
    }

    protected DataSourceProvider dataSourceProvider() {
        return new HSQLDBDataSourceProvider();
    }

    protected List<Type> additionalTypes() {
        return null;
    }

    protected <T> T doInHibernate(HibernateTransactionFunction<T> callable) {
        T result = null;
        Session session = null;
        Transaction txn = null;
        try {
            session = this.sessionFactory().openSession();
            callable.beforeTransactionCompletion();
            txn = session.beginTransaction();
            result = callable.apply(session);
            if (txn.getLocalStatus() == LocalStatus.ACTIVE) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.getLocalStatus() == LocalStatus.ACTIVE) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw new RuntimeException(t);
        }
        finally {
            callable.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
        return result;
    }

    protected void doInHibernate(HibernateTransactionConsumer callable) {
        Session session = null;
        Transaction txn = null;
        try {
            session = this.sessionFactory().openSession();
            callable.beforeTransactionCompletion();
            txn = session.beginTransaction();
            callable.accept(session);
            if (txn.getLocalStatus() == LocalStatus.ACTIVE) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.getLocalStatus() == LocalStatus.ACTIVE) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw new RuntimeException(t);
        }
        finally {
            callable.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
    }

    protected <T> T doInJPA(JPATransactionFunction<T> function) {
        T result = null;
        EntityManager entityManager = null;
        EntityTransaction txn = null;
        try {
            entityManager = this.entityManagerFactory().createEntityManager();
            function.beforeTransactionCompletion();
            txn = entityManager.getTransaction();
            txn.begin();
            result = function.apply(entityManager);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw new RuntimeException(t);
        }
        finally {
            function.afterTransactionCompletion();
            if (entityManager != null) {
                entityManager.close();
            }
        }
        return result;
    }

    protected void doInJPA(JPATransactionVoidFunction function) {
        EntityManager entityManager = null;
        EntityTransaction txn = null;
        try {
            entityManager = this.entityManagerFactory().createEntityManager();
            function.beforeTransactionCompletion();
            txn = entityManager.getTransaction();
            txn.begin();
            function.accept(entityManager);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw new RuntimeException(t);
        }
        finally {
            function.afterTransactionCompletion();
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    protected <T> T doInJDBC(final ConnectionCallable<T> callable) {
        final AtomicReference result = new AtomicReference();
        Session session = null;
        Transaction txn = null;
        try {
            session = this.sessionFactory().openSession();
            txn = session.beginTransaction();
            session.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    result.set(callable.execute(connection));
                }
            });
            if (txn.getLocalStatus() == LocalStatus.ACTIVE) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.getLocalStatus() == LocalStatus.ACTIVE) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw new RuntimeException(t);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return (T)result.get();
    }

    protected void doInJDBC(final ConnectionVoidCallable callable) {
        Session session = null;
        Transaction txn = null;
        try {
            session = this.sessionFactory().openSession();
            txn = session.beginTransaction();
            session.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    callable.execute(connection);
                }
            });
            if (txn.getLocalStatus() == LocalStatus.ACTIVE) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.getLocalStatus() == LocalStatus.ACTIVE) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw new RuntimeException(t);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    static {
        Thread.currentThread().setName("Alice");
    }
}

