/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.vladmihalcea.hibernate.type.json.JsonNodeBinaryType;
import com.vladmihalcea.hibernate.type.json.internal.JacksonUtil;
import com.vladmihalcea.hibernate.type.util.AbstractPostgreSQLIntegrationTest;
import com.vladmihalcea.hibernate.type.util.transaction.JPATransactionFunction;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.junit.Test;

public class PostgreSQLJsonNodeBinaryTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Test
    public void test() {
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                Book book = new Book();
                book.setIsbn("978-9730228236");
                book.setProperties(JacksonUtil.toJsonNode((String)"{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99}"));
                entityManager.persist((Object)book);
                return null;
            }
        });
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                Session session = (Session)entityManager.unwrap(Session.class);
                Book book = (Book)session.bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
                PostgreSQLJsonNodeBinaryTypeTest.this.LOGGER.info("Book details: {}", (Object)book.getProperties());
                book.setProperties(JacksonUtil.toJsonNode((String)"{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99,   \"url\": \"https://www.amazon.com/High-Performance-Java-Persistence-Vlad-Mihalcea/dp/973022823X/\"}"));
                return null;
            }
        });
    }

    @Entity(name="Book")
    @Table(name="book")
    @TypeDef(name="jsonb-node", typeClass=JsonNodeBinaryType.class)
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String isbn;
        @Type(type="jsonb-node")
        @Column(columnDefinition="jsonb")
        private JsonNode properties;

        public String getIsbn() {
            return this.isbn;
        }

        public void setIsbn(String isbn) {
            this.isbn = isbn;
        }

        public JsonNode getProperties() {
            return this.properties;
        }

        public void setProperties(JsonNode properties) {
            this.properties = properties;
        }
    }
}

