/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.json;

import com.vladmihalcea.hibernate.type.model.BaseEntity;
import com.vladmihalcea.hibernate.type.model.Location;
import com.vladmihalcea.hibernate.type.model.Ticket;
import com.vladmihalcea.hibernate.type.util.AbstractMySQLIntegrationTest;
import com.vladmihalcea.hibernate.type.util.transaction.JPATransactionFunction;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class MySQLJsonTypeTest
extends AbstractMySQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class, Participant.class};
    }

    @Override
    protected String[] packages() {
        return new String[]{Location.class.getPackage().getName()};
    }

    @Test
    public void test() {
        final AtomicReference eventHolder = new AtomicReference();
        final AtomicReference participantHolder = new AtomicReference();
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                Event nullEvent = new Event();
                nullEvent.setId(0L);
                entityManager.persist((Object)nullEvent);
                Location location = new Location();
                location.setCountry("Romania");
                location.setCity("Cluj-Napoca");
                Event event = new Event();
                event.setId(1L);
                event.setLocation(location);
                entityManager.persist((Object)event);
                Ticket ticket = new Ticket();
                ticket.setPrice(12.34);
                ticket.setRegistrationCode("ABC123");
                Participant participant = new Participant();
                participant.setId(1L);
                participant.setTicket(ticket);
                participant.setEvent(event);
                entityManager.persist((Object)participant);
                eventHolder.set(event);
                participantHolder.set(participant);
                return null;
            }
        });
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                Event event = (Event)entityManager.find(Event.class, (Object)((Event)eventHolder.get()).getId());
                Assert.assertEquals((Object)"Cluj-Napoca", (Object)event.getLocation().getCity());
                Participant participant = (Participant)entityManager.find(Participant.class, (Object)((Participant)participantHolder.get()).getId());
                Assert.assertEquals((Object)"ABC123", (Object)participant.getTicket().getRegistrationCode());
                List participants = entityManager.createNativeQuery("select p.ticket -> \"$.registrationCode\" from participant p where JSON_EXTRACT(p.ticket, \"$.price\") > 1 ").getResultList();
                event.getLocation().setCity("Constan\u021ba");
                entityManager.flush();
                Assert.assertEquals((long)1L, (long)participants.size());
                return null;
            }
        });
    }

    @Entity(name="Participant")
    @Table(name="participant")
    public static class Participant
    extends BaseEntity {
        @Type(type="json")
        @Column(columnDefinition="json")
        private Ticket ticket;
        @ManyToOne
        private Event event;

        public Ticket getTicket() {
            return this.ticket;
        }

        public void setTicket(Ticket ticket) {
            this.ticket = ticket;
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(type="json")
        @Column(columnDefinition="json")
        private Location location;

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }
    }
}

