/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.hibernate.type.array;

import com.vladmihalcea.hibernate.type.array.PostgreSQL9ArrayDialect;
import com.vladmihalcea.hibernate.type.model.BaseEntity;
import com.vladmihalcea.hibernate.type.util.AbstractPostgreSQLIntegrationTest;
import com.vladmihalcea.hibernate.type.util.providers.DataSourceProvider;
import com.vladmihalcea.hibernate.type.util.providers.PostgreSQLDataSourceProvider;
import com.vladmihalcea.hibernate.type.util.transaction.JPATransactionFunction;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class ArrayTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    protected DataSourceProvider dataSourceProvider() {
        return new PostgreSQLDataSourceProvider(){

            @Override
            public String hibernateDialect() {
                return PostgreSQL9ArrayDialect.class.getName();
            }
        };
    }

    @Test
    public void test() {
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                Event nullEvent = new Event();
                nullEvent.setId(0L);
                entityManager.persist((Object)nullEvent);
                Event event = new Event();
                event.setId(1L);
                event.setSensorNames(new String[]{"Temperature", "Pressure"});
                event.setSensorValues(new int[]{12, 756});
                entityManager.persist((Object)event);
                return null;
            }
        });
        this.doInJPA(new JPATransactionFunction<Void>(){

            @Override
            public Void apply(EntityManager entityManager) {
                Event event = (Event)entityManager.find(Event.class, (Object)1L);
                Assert.assertArrayEquals((Object[])new String[]{"Temperature", "Pressure"}, (Object[])event.getSensorNames());
                Assert.assertArrayEquals((int[])new int[]{12, 756}, (int[])event.getSensorValues());
                return null;
            }
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(type="string-array")
        @Column(name="sensor_names", columnDefinition="text[]")
        private String[] sensorNames;
        @Type(type="int-array")
        @Column(name="sensor_values", columnDefinition="integer[]")
        private int[] sensorValues;

        public String[] getSensorNames() {
            return this.sensorNames;
        }

        public void setSensorNames(String[] sensorNames) {
            this.sensorNames = sensorNames;
        }

        public int[] getSensorValues() {
            return this.sensorValues;
        }

        public void setSensorValues(int[] sensorValues) {
            this.sensorValues = sensorValues;
        }
    }
}

