/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ReadOnlyHasValue;
import com.vaadin.flow.data.binder.testcomponents.TestLabel;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReadOnlyHasValueTest {
    private static final String SAY_SOMETHING = "Say something";
    private static final String SAY_SOMETHING_ELSE = "Say something else";
    private static final String NO_VALUE = "-no-value-";
    private TestLabel label;
    private ReadOnlyHasValue<String> hasValue;

    @Before
    public void setup() {
        this.label = new TestLabel();
        this.hasValue = new ReadOnlyHasValue(arg_0 -> ((TestLabel)this.label).setText(arg_0));
    }

    @Test
    public void testBase() {
        this.hasValue.setReadOnly(true);
        this.hasValue.setRequiredIndicatorVisible(false);
        Registration registration = this.hasValue.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {});
        registration.remove();
        this.hasValue.setValue((Object)SAY_SOMETHING);
        Assert.assertEquals((Object)SAY_SOMETHING, (Object)this.hasValue.getValue());
        Assert.assertEquals((Object)SAY_SOMETHING, (Object)this.label.getText());
        this.hasValue.setValue((Object)SAY_SOMETHING_ELSE);
        Assert.assertEquals((Object)SAY_SOMETHING_ELSE, (Object)this.hasValue.getValue());
        Assert.assertEquals((Object)SAY_SOMETHING_ELSE, (Object)this.label.getText());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRO() {
        this.hasValue.setReadOnly(false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIndicator() {
        this.hasValue.setRequiredIndicatorVisible(true);
    }

    @Test
    public void testBind() {
        Binder beanBinder = new Binder(Bean.class);
        TestLabel label = new TestLabel();
        ReadOnlyHasValue intHasValue = new ReadOnlyHasValue((SerializableConsumer & Serializable)i -> label.setText(Objects.toString(i, "")));
        beanBinder.forField((HasValue)intHasValue).bind("v");
        beanBinder.readBean((Object)new Bean(42L));
        Assert.assertEquals((Object)"42", (Object)label.getText());
        Assert.assertEquals((long)42L, (long)((Long)intHasValue.getValue()));
        Registration registration = intHasValue.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            Assert.assertEquals((long)42L, (long)((Long)e.getOldValue()));
            Assert.assertSame((Object)intHasValue, (Object)e.getHasValue());
            Assert.assertFalse((boolean)e.isFromClient());
        });
        beanBinder.readBean((Object)new Bean(1984L));
        Assert.assertEquals((Object)"1984", (Object)label.getText());
        Assert.assertEquals((long)1984L, (long)((Long)intHasValue.getValue()));
        registration.remove();
        beanBinder.readBean(null);
        Assert.assertEquals((Object)"", (Object)label.getText());
        Assert.assertEquals(null, (Object)intHasValue.getValue());
    }

    @Test
    public void testEmptyValue() {
        Binder beanBinder = new Binder(Bean.class);
        TestLabel label = new TestLabel();
        ReadOnlyHasValue strHasValue = new ReadOnlyHasValue(arg_0 -> ((TestLabel)label).setText(arg_0), (Object)NO_VALUE);
        beanBinder.forField((HasValue)strHasValue).withConverter(Long::parseLong, (SerializableFunction & Serializable)i -> "" + i).bind("v");
        beanBinder.readBean((Object)new Bean(42L));
        Assert.assertEquals((Object)"42", (Object)label.getText());
        beanBinder.readBean(null);
        Assert.assertEquals((Object)NO_VALUE, (Object)label.getText());
        Assert.assertTrue((boolean)strHasValue.isEmpty());
    }

    public static class Bean {
        private long v;

        public Bean(long v) {
            this.v = v;
        }

        public long getV() {
            return this.v;
        }

        public void setV(long v) {
            this.v = v;
        }
    }
}

