/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider.hierarchy;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalArrayUpdater;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataCommunicator;
import com.vaadin.flow.data.provider.hierarchy.HierarchicalDataProvider;
import com.vaadin.flow.data.provider.hierarchy.TreeData;
import com.vaadin.flow.data.provider.hierarchy.TreeDataProvider;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HierarchicalCommunicatorTest {
    private static final String ROOT = "ROOT";
    private static final String FOLDER = "FOLDER";
    private static final String LEAF = "LEAF";
    private TreeDataProvider<String> dataProvider;
    private HierarchicalDataCommunicator<String> communicator;
    private TreeData<String> treeData;
    private UI ui;
    private UIInternals uiInternals;
    private StateTree stateTree;
    private final int pageSize = 50;
    private StateNode stateNode;
    private List<String> enqueueFunctions = new ArrayList<String>();
    private final HierarchicalArrayUpdater arrayUpdater = new HierarchicalArrayUpdater(){

        public HierarchicalArrayUpdater.HierarchicalUpdate startUpdate(int sizeChange) {
            return new UpdateQueue();
        }

        public void initialize() {
        }
    };

    @Before
    public void setUp() {
        this.ui = (UI)Mockito.mock(UI.class);
        this.uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        this.stateTree = (StateTree)Mockito.mock(StateTree.class);
        Mockito.when((Object)this.ui.getInternals()).thenReturn((Object)this.uiInternals);
        Mockito.when((Object)this.uiInternals.getStateTree()).thenReturn((Object)this.stateTree);
        this.treeData = new TreeData();
        this.treeData.addItems(null, (Object[])new String[]{ROOT});
        this.treeData.addItems((Object)ROOT, (Object[])new String[]{FOLDER});
        this.treeData.addItems((Object)FOLDER, (Object[])new String[]{LEAF});
        this.dataProvider = new TreeDataProvider(this.treeData);
        this.stateNode = (StateNode)Mockito.mock(StateNode.class);
        Mockito.when((Object)this.stateNode.hasFeature((Class)Mockito.any())).thenReturn((Object)true);
        ComponentMapping mapping = (ComponentMapping)Mockito.mock(ComponentMapping.class);
        Mockito.when((Object)this.stateNode.getFeatureIfInitialized(ComponentMapping.class)).thenReturn(Optional.ofNullable(mapping));
        Mockito.when((Object)mapping.getComponent()).thenReturn(Optional.of(new TestComponent()));
        this.communicator = new HierarchicalDataCommunicator((CompositeDataGenerator)Mockito.mock(CompositeDataGenerator.class), this.arrayUpdater, (SerializableConsumer & Serializable)json -> {}, this.stateNode, (SerializableSupplier & Serializable)() -> null);
        this.communicator.setDataProvider(this.dataProvider, null);
    }

    @Test
    public void folderRemoveRefreshAll() {
        this.testItemRemove(FOLDER, true);
    }

    @Test
    public void leafRemoveRefreshAll() {
        this.testItemRemove(LEAF, true);
    }

    @Test
    public void folderRemove() {
        this.testItemRemove(FOLDER, false);
    }

    @Test
    public void leafRemove() {
        this.testItemRemove(LEAF, false);
    }

    private void testItemRemove(String item, boolean refreshAll) {
        this.communicator.expand((Object)ROOT);
        this.communicator.expand((Object)FOLDER);
        this.communicator.refresh((Object)item);
        this.treeData.removeItem((Object)item);
        if (refreshAll) {
            this.dataProvider.refreshAll();
        } else {
            this.dataProvider.refreshItem((Object)item);
        }
        int number = refreshAll ? 6 : 5;
        ArgumentCaptor attachCaptor = ArgumentCaptor.forClass(SerializableConsumer.class);
        ((StateNode)Mockito.verify((Object)this.stateNode, (VerificationMode)Mockito.times((int)number))).runWhenAttached((SerializableConsumer)attachCaptor.capture());
        attachCaptor.getAllValues().forEach(consumer -> consumer.accept((Object)this.ui));
        ((StateTree)Mockito.verify((Object)this.stateTree, (VerificationMode)Mockito.times((int)number))).beforeClientResponse((StateNode)Mockito.any(), (SerializableConsumer)Mockito.any());
    }

    @Test
    public void replaceAll() {
        this.communicator.expand((Object)ROOT);
        this.communicator.expand((Object)FOLDER);
        this.communicator.refresh((Object)LEAF);
        this.communicator.setDataProvider((HierarchicalDataProvider)new TreeDataProvider(new TreeData()), null);
        this.dataProvider.refreshAll();
        Assert.assertFalse((String)"Stalled object in KeyMapper", (boolean)this.communicator.getKeyMapper().has((Object)ROOT));
        Assert.assertEquals((long)-1L, (long)this.communicator.getParentIndex((Object)FOLDER).longValue());
    }

    @Test
    public void reset_noDataControllers_hierarchicalUpdateIsCalled() {
        this.enqueueFunctions.clear();
        this.communicator.reset();
        Assert.assertEquals((long)1L, (long)this.enqueueFunctions.size());
        Assert.assertEquals((Object)"$connector.ensureHierarchy", (Object)this.enqueueFunctions.get(0));
    }

    @Tag(value="test")
    public static class TestComponent
    extends Component {
    }

    private class UpdateQueue
    implements HierarchicalArrayUpdater.HierarchicalUpdate {
        private UpdateQueue() {
        }

        public void clear(int start, int length) {
        }

        public void set(int start, List<JsonValue> items) {
        }

        public void commit(int updateId) {
        }

        public void enqueue(String name, Serializable ... arguments) {
            HierarchicalCommunicatorTest.this.enqueueFunctions.add(name);
        }

        public void set(int start, List<JsonValue> items, String parentKey) {
        }

        public void clear(int start, int length, String parentKey) {
        }

        public void commit(int updateId, String parentKey, int levelSize) {
        }

        public void commit() {
        }
    }
}

