/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;

public class CustomInMemoryDataProvider<T>
implements InMemoryDataProvider<T> {
    private List<T> items;
    private SerializablePredicate<T> filter = (SerializablePredicate & Serializable)in -> true;
    private SerializableComparator<T> comparator;

    public CustomInMemoryDataProvider(List<T> items) {
        this.items = items;
    }

    public SerializablePredicate<T> getFilter() {
        return this.filter;
    }

    public void setFilter(SerializablePredicate<T> filter) {
        this.filter = filter;
    }

    public SerializableComparator<T> getSortComparator() {
        return this.comparator;
    }

    public void setSortComparator(SerializableComparator<T> comparator) {
        this.comparator = comparator;
    }

    public int size(Query<T, SerializablePredicate<T>> query) {
        return (int)this.items.stream().filter(this.filter).count();
    }

    public Stream<T> fetch(Query<T, SerializablePredicate<T>> query) {
        Stream filteredStream = this.items.stream().filter(this.filter);
        if (this.comparator != null) {
            filteredStream = filteredStream.sorted(this.comparator);
        }
        return filteredStream.skip(query.getOffset()).limit(query.getLimit());
    }

    public void refreshItem(T item) {
    }

    public void refreshAll() {
    }

    public Registration addDataProviderListener(DataProviderListener<T> listener) {
        return (Registration & Serializable)() -> {};
    }
}

