/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.google.common.primitives.Chars;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.data.provider.AbstractDataViewTest;
import com.vaadin.flow.data.provider.AbstractListDataView;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.tests.data.bean.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractListDataViewTest {
    private Collection<String> items;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();
    private ListDataProvider<String> dataProvider;
    private AbstractListDataView<String> dataView;
    private Component component;
    private AbstractListDataView<Item> beanDataView;
    private ListDataProvider<Item> itemListDataProvider;

    @Before
    public void init() {
        this.items = new ArrayList<String>(Arrays.asList("first", "middle", "last"));
        this.dataProvider = DataProvider.ofCollection(this.items);
        this.component = new TestComponent();
        this.dataView = new ListDataViewImpl((SerializableSupplier & Serializable)() -> this.dataProvider, this.component);
        this.itemListDataProvider = DataProvider.ofCollection(this.getTestItems());
        this.beanDataView = new ItemListDataView((SerializableSupplier & Serializable)() -> this.itemListDataProvider, this.component);
    }

    @Test
    public void createListDataViewInstance_faultyDataProvider_throwsException() {
        CallbackDataProvider dataProvider = DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)query -> Stream.of("one"), (CallbackDataProvider.CountCallback & Serializable)query -> 1);
        this.exceptionRule.expect(IllegalStateException.class);
        this.exceptionRule.expectMessage("ListDataViewImpl only supports 'ListDataProvider' or it's subclasses, but was given a 'AbstractBackEndDataProvider'");
        new ListDataViewImpl(() -> AbstractListDataViewTest.lambda$createListDataViewInstance_faultyDataProvider_throwsException$f9a249dc$1((DataProvider)dataProvider), null);
    }

    @Test
    public void getItemCount_noFiltersSet_dataSizeObtained() {
        Assert.assertEquals((String)"Unexpected item count", (long)this.items.size(), (long)this.dataView.getItemCount());
    }

    @Test
    public void getItemCount_filtersSet_filteredItemsObtained() {
        this.dataProvider.setFilter((SerializablePredicate & Serializable)item -> item.equals("first"));
        Assert.assertEquals((String)"Unexpected item count", (long)1L, (long)this.dataView.getItemCount());
    }

    @Test
    public void getNextItem_nextItemAvailable_nextItemFound() {
        Optional middle = this.dataView.getNextItem((Object)"middle");
        Assert.assertTrue((boolean)middle.isPresent());
        Assert.assertEquals((String)"Faulty next item", (Object)"last", middle.get());
    }

    @Test
    public void getNextItem_nextItemUnavailable_nextItemNotFound() {
        Assert.assertFalse((String)"Got next item for last item", (boolean)this.dataView.getNextItem((Object)"last").isPresent());
    }

    @Test
    public void getPrevItem_prevItemAvailable_prevItemFound() {
        Optional middle = this.dataView.getPreviousItem((Object)"middle");
        Assert.assertTrue((boolean)middle.isPresent());
        Assert.assertEquals((String)"Item in middle should have previous item", (Object)"first", middle.get());
    }

    @Test
    public void getPrevItem_prevItemUnavailable_prevItemNotFound() {
        Assert.assertFalse((String)"Got previous item for first index", (boolean)this.dataView.getPreviousItem((Object)"first").isPresent());
    }

    @Test
    public void setFilter_filterIsSet_filteredItemsObtained() {
        Assert.assertEquals((long)this.items.size(), (long)this.dataView.getItemCount());
        this.dataView.setFilter((SerializablePredicate & Serializable)item -> item.equals("first"));
        Assert.assertEquals((String)"Filter was not applied to data size", (long)1L, (long)this.dataView.getItemCount());
        Assert.assertEquals((String)"Expected item is missing from filtered data", (Object)"first", this.dataView.getItems().findFirst().get());
    }

    @Test
    public void setFilter_filterReset_allItemsObtained() {
        this.dataProvider.setFilter((SerializablePredicate & Serializable)item -> item.equals("first"));
        this.dataView.setFilter(null);
        Assert.assertEquals((String)"Filter reset was not applied to data size", (long)this.items.size(), (long)this.dataView.getItemCount());
        Assert.assertArrayEquals((String)"Filter reset was not applied to data set", (Object[])this.items.toArray(), (Object[])this.dataView.getItems().toArray());
    }

    @Test
    public void setSortComparator_sortIsSet_sortedItemsObtained() {
        this.dataView.setSortComparator(String::compareTo);
        Assert.assertEquals((String)"Unexpected data set order after comparator setup", (Object)"first,last,middle", (Object)this.dataView.getItems().collect(Collectors.joining(",")));
    }

    @Test
    public void setSortComparator_sortingReset_sortingResetToInitial() {
        this.dataProvider.setSortComparator(String::compareTo);
        this.dataView.setSortComparator(null);
        Assert.assertArrayEquals((String)"Sorting reset was not applied to data set", (Object[])this.items.toArray(), (Object[])this.dataView.getItems().toArray());
    }

    @Test
    public void addSortComparator_twoComparatorsAdded_itemsSortedByCompositeComparator() {
        this.dataProvider = DataProvider.ofItems((Object[])new String[]{"b3", "a2", "a1"});
        this.dataView = new ListDataViewImpl((SerializableSupplier & Serializable)() -> this.dataProvider, this.component);
        this.dataView.addSortComparator((SerializableComparator & Serializable)(s1, s2) -> Chars.compare((char)s1.charAt(0), (char)s2.charAt(0)));
        Assert.assertEquals((String)"Unexpected data set order (comparator 1)", (Object)"a2,a1,b3", (Object)this.dataView.getItems().collect(Collectors.joining(",")));
        this.dataView.addSortComparator((SerializableComparator & Serializable)(s1, s2) -> Chars.compare((char)s1.charAt(1), (char)s2.charAt(1)));
        Assert.assertEquals((String)"Unexpected data set order (comparator 2)", (Object)"a1,a2,b3", (Object)this.dataView.getItems().collect(Collectors.joining(",")));
    }

    @Test
    public void setSortOrder_sortOrderIsSet_sortedItemsObtained() {
        this.dataView.setSortOrder(ValueProvider.identity(), SortDirection.ASCENDING);
        Assert.assertEquals((String)"Unexpected data set order", (Object)"first,last,middle", (Object)this.dataView.getItems().collect(Collectors.joining(",")));
    }

    @Test
    public void addSortOrder_twoOrdersAdded_itemsSortedByCompositeOrders() {
        this.dataProvider = DataProvider.ofItems((Object[])new String[]{"b3", "a1", "a2"});
        this.dataView = new ListDataViewImpl((SerializableSupplier & Serializable)() -> this.dataProvider, null);
        this.dataView.addSortOrder((ValueProvider & Serializable)item -> Character.valueOf(item.charAt(0)), SortDirection.DESCENDING);
        Assert.assertEquals((String)"Unexpected data set order (order 1)", (Object)"b3,a1,a2", (Object)this.dataView.getItems().collect(Collectors.joining(",")));
        this.dataView.addSortOrder((ValueProvider & Serializable)item -> Character.valueOf(item.charAt(1)), SortDirection.DESCENDING);
        Assert.assertEquals((String)"Unexpected data set order (order 2)", (Object)"b3,a2,a1", (Object)this.dataView.getItems().collect(Collectors.joining(",")));
    }

    @Test
    public void removeSorting_sortingSetAndThenRemoved_initialSortingObtained() {
        this.dataView.setSortOrder(ValueProvider.identity(), SortDirection.ASCENDING);
        Assert.assertEquals((String)"Unexpected data set order", (Object)"first,last,middle", (Object)this.dataView.getItems().collect(Collectors.joining(",")));
        this.dataView.removeSorting();
        Assert.assertEquals((String)"Unexpected data set order", (Object)"first,middle,last", (Object)this.dataView.getItems().collect(Collectors.joining(",")));
    }

    @Test
    public void contains_itemPresentedInDataSet_itemFound() {
        Assert.assertTrue((String)"Set item was not found in the data", (boolean)this.dataView.contains((Object)"first"));
    }

    @Test
    public void contains_itemNotPresentedInDataSet_itemNotFound() {
        Assert.assertFalse((String)"Non existent item found in data", (boolean)this.dataView.contains((Object)"absent item"));
    }

    @Test
    public void setIdentifierProvider_defaultIdentity_equalsIsUsed() {
        Assert.assertTrue((boolean)this.beanDataView.contains((Object)new Item(1L, "value1")));
        Assert.assertFalse((boolean)this.beanDataView.contains((Object)new Item(1L, "non present")));
        Assert.assertFalse((boolean)this.beanDataView.contains((Object)new Item(4L, "value1")));
    }

    @Test
    public void setIdentifierProvider_dataProviderIdentity_getIdIsUsed() {
        this.itemListDataProvider = new AbstractDataViewTest.CustomIdentityItemDataProvider(this.getTestItems());
        Assert.assertTrue((boolean)this.beanDataView.contains((Object)new Item(1L, "value1")));
        Assert.assertTrue((boolean)this.beanDataView.contains((Object)new Item(1L, "non present")));
        Assert.assertFalse((boolean)this.beanDataView.contains((Object)new Item(4L, "value1")));
    }

    @Test
    public void setIdentifierProvider_customIdentifierProvider_customIdentifierProviderIsUsed() {
        this.beanDataView.setIdentifierProvider(Item::getValue);
        Assert.assertTrue((boolean)this.beanDataView.contains((Object)new Item(1L, "value1")));
        Assert.assertFalse((boolean)this.beanDataView.contains((Object)new Item(1L, "non present")));
        Assert.assertTrue((boolean)this.beanDataView.contains((Object)new Item(4L, "value1")));
    }

    @Test
    public void setIdentifierProvider_dataProviderHasChanged_newDataProviderIsUsed() {
        Assert.assertFalse((boolean)this.beanDataView.contains((Object)new Item(1L, "non present")));
        this.itemListDataProvider = new AbstractDataViewTest.CustomIdentityItemDataProvider(this.getTestItems());
        Assert.assertTrue((boolean)this.beanDataView.contains((Object)new Item(1L, "non present")));
        this.itemListDataProvider = DataProvider.ofItems((Object[])new Item[]{new Item(10L, "description10")});
        Assert.assertFalse((boolean)this.beanDataView.contains((Object)new Item(1L, "non present")));
        Assert.assertTrue((boolean)this.beanDataView.contains((Object)new Item(10L, "description10")));
    }

    @Test
    public void setIdentifierProvider_dataProviderHasChanged_identifierProviderRetained() {
        Assert.assertFalse((boolean)this.beanDataView.contains((Object)new Item(4L, "non present", "descr1")));
        this.beanDataView.setIdentifierProvider(Item::getDescription);
        Assert.assertTrue((boolean)this.beanDataView.contains((Object)new Item(4L, "non present", "descr1")));
        this.itemListDataProvider = new AbstractDataViewTest.CustomIdentityItemDataProvider(this.getTestItems());
        Assert.assertTrue((boolean)this.beanDataView.contains((Object)new Item(4L, "non present", "descr1")));
    }

    @Test
    public void contains_filterApplied_itemFilteredOut() {
        Assert.assertTrue((boolean)this.beanDataView.contains((Object)new Item(1L, "value1")));
        this.beanDataView.setFilter((SerializablePredicate & Serializable)item -> item.getId() > 1L);
        Assert.assertFalse((boolean)this.beanDataView.contains((Object)new Item(1L, "value1")));
        Assert.assertTrue((boolean)this.beanDataView.contains((Object)new Item(3L, "value3")));
    }

    @Test
    public void addItem_itemInDataset() {
        String newItem = "new Item";
        this.dataView.addItem((Object)"new Item");
        Assert.assertEquals((long)4L, (long)this.dataView.getItemCount());
        Assert.assertTrue((boolean)this.dataView.contains((Object)"new Item"));
        Optional optionalItem = this.dataView.getNextItem((Object)"last");
        Assert.assertTrue((boolean)optionalItem.isPresent());
        Assert.assertEquals((Object)"new Item", optionalItem.get());
    }

    @Test
    public void addItem_itemAlreadyInList_notAdded() {
        String newItem = "first";
        this.dataView.addItem((Object)"first");
        Assert.assertEquals((long)3L, (long)this.dataView.getItemCount());
        Assert.assertTrue((boolean)this.dataView.contains((Object)"first"));
    }

    @Test
    public void removeItem_itemRemovedFromDataset() {
        this.dataView.removeItem((Object)"middle");
        Assert.assertEquals((long)2L, (long)this.dataView.getItemCount());
        Assert.assertFalse((boolean)this.dataView.contains((Object)"middle"));
        Optional optionalItem = this.dataView.getNextItem((Object)"first");
        Assert.assertTrue((boolean)optionalItem.isPresent());
        Assert.assertEquals((Object)"last", optionalItem.get());
    }

    @Test
    public void removeItem_notInList_dataSetNotChanged() {
        this.dataView.removeItem((Object)"not present");
        Assert.assertEquals((long)3L, (long)this.dataView.getItemCount());
    }

    @Test
    public void addItemBefore_itemIsAddedAtExpectedPosition() {
        this.dataView.addItemBefore((Object)"newItem", (Object)"middle");
        Assert.assertArrayEquals((Object[])new String[]{"first", "newItem", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
        this.dataView.addItemBefore((Object)"second", (Object)"first");
        Assert.assertArrayEquals((Object[])new String[]{"second", "first", "newItem", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemBefore_itemAlreadyInList_itemIsMovedAtExpectedPosition() {
        String newItem = "newItem";
        this.dataView.addItem((Object)"newItem");
        this.dataView.addItemBefore((Object)"newItem", (Object)"middle");
        Assert.assertArrayEquals((Object[])new String[]{"first", "newItem", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemBefore_itemAndTargetAreTheSame_itemIsNotAdded() {
        this.dataView.addItemBefore((Object)"newItem", (Object)"newItem");
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemBefore_itemNotInCollection_throwsException() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("Item to insert before is not available in the data");
        this.dataView.addItemBefore((Object)"newItem", (Object)"notExistent");
    }

    @Test
    public void addItemBefore_addItemInFilteredDataSet_itemAddedBeforeTheTarget() {
        this.dataView.addFilter((SerializablePredicate & Serializable)item -> !item.equalsIgnoreCase("first"));
        this.dataView.addItemBefore((Object)"newItem", (Object)"last");
        Assert.assertArrayEquals((Object[])new String[]{"middle", "newItem", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemAfter_itemIsAddedAtExpectedPosition() {
        this.dataView.addItemAfter((Object)"newItem", (Object)"middle");
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "newItem", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
        this.dataView.addItemAfter((Object)"second", (Object)"last");
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "newItem", "last", "second"}, (Object[])this.dataView.getItems().toArray(String[]::new));
        this.dataView.addItemAfter((Object)"middle", (Object)"last");
        Assert.assertArrayEquals((Object[])new String[]{"first", "newItem", "last", "middle", "second"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemAfter_itemAlreadyInList_itemIsMovedAtExpectedPosition() {
        String newItem = "newItem";
        this.dataView.addItem((Object)"newItem");
        this.dataView.addItemAfter((Object)"newItem", (Object)"middle");
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "newItem", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemAfter_itemAndTargetAreTheSame_itemIsNotAdded() {
        this.dataView.addItemAfter((Object)"newItem", (Object)"newItem");
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemAfter_itemNotInCollection_throwsException() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("Item to insert after is not available in the data");
        this.dataView.addItemAfter((Object)"newItem", (Object)"notExistent");
    }

    @Test
    public void addItemAfter_addItemInFilteredDataSet_itemAddedAfterTheTarget() {
        this.dataView.addFilter((SerializablePredicate & Serializable)item -> !item.equalsIgnoreCase("first"));
        this.dataView.addItemAfter((Object)"newItem", (Object)"last");
        Assert.assertArrayEquals((Object[])new String[]{"middle", "last", "newItem"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItems_allItemsAreAdded() {
        this.dataView.addItems(Arrays.asList("newOne", "newTwo", "newThree"));
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "last", "newOne", "newTwo", "newThree"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItems_someItemsAlreadyInList_allItemsAreMovedAtTheEndAndOrdered() {
        this.dataView.addItems(Arrays.asList("first", "newOne", "newTwo"));
        Assert.assertArrayEquals((Object[])new String[]{"middle", "last", "first", "newOne", "newTwo"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItems_nullCollectionPassed_throwsException() {
        this.exceptionRule.expect(NullPointerException.class);
        this.exceptionRule.expectMessage("Items collection cannot be null");
        this.dataView.addItems(null);
    }

    @Test
    public void addItems_emptyCollectionPassed_dataNotChanged() {
        this.dataView.addItems(Collections.emptyList());
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemsAfter_allItemsAreAddedAfterTargetItem() {
        this.dataView.addItemsAfter(Arrays.asList("newOne", "newTwo", "newThree"), (Object)"first");
        Assert.assertArrayEquals((Object[])new String[]{"first", "newOne", "newTwo", "newThree", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemsAfter_someItemsAlreadyInList_allItemsAreMovedAfterTargetAndOrdered() {
        this.dataView.addItemsAfter(Arrays.asList("middle", "newOne", "newTwo"), (Object)"first");
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "newOne", "newTwo", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
        this.dataView.addItemsAfter(Collections.singletonList("newThree"), (Object)"last");
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "newOne", "newTwo", "last", "newThree"}, (Object[])this.dataView.getItems().toArray(String[]::new));
        this.dataView.addItemsAfter(Arrays.asList("newFour", "newThree"), (Object)"newThree");
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "newOne", "newTwo", "last", "newFour", "newThree"}, (Object[])this.dataView.getItems().toArray(String[]::new));
        this.dataView.addItemsAfter(Arrays.asList("newFive", "first"), (Object)"first");
        Assert.assertArrayEquals((Object[])new String[]{"newFive", "first", "middle", "newOne", "newTwo", "last", "newFour", "newThree"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemsAfter_targetItemNotInCollection_throwsException() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("Item to insert after is not available in the data");
        this.dataView.addItemsAfter(Collections.singletonList("newItem"), (Object)"notExistent");
    }

    @Test
    public void addItemsAfter_nullCollectionPassed_throwsException() {
        this.exceptionRule.expect(NullPointerException.class);
        this.exceptionRule.expectMessage("Items collection cannot be null");
        this.dataView.addItemsAfter(null, (Object)"any");
    }

    @Test
    public void addItemsAfter_emptyCollectionPassed_dataNotChanged() {
        this.dataView.addItemsAfter(Collections.emptyList(), (Object)"any");
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemsAfter_addItemsInFilteredDataSet_itemsAddedAfterTheTarget() {
        this.dataView.addFilter((SerializablePredicate & Serializable)item -> !item.equalsIgnoreCase("first"));
        this.dataView.addItemsAfter(Arrays.asList("newItem1", "newItem2"), (Object)"last");
        Assert.assertArrayEquals((Object[])new String[]{"middle", "last", "newItem1", "newItem2"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemsBefore_allItemsAreAddedBeforeTargetItem() {
        this.dataView.addItemsBefore(Arrays.asList("newOne", "newTwo", "newThree"), (Object)"middle");
        Assert.assertArrayEquals((Object[])new String[]{"first", "newOne", "newTwo", "newThree", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemsBefore_someItemsAlreadyInList_allItemsAreMovedBeforeTargetAndOrdered() {
        this.dataView.addItemsBefore(Arrays.asList("first", "newOne", "newTwo"), (Object)"last");
        Assert.assertArrayEquals((Object[])new String[]{"middle", "first", "newOne", "newTwo", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
        this.dataView.addItemsBefore(Arrays.asList("newThree", "last"), (Object)"last");
        Assert.assertArrayEquals((Object[])new String[]{"middle", "first", "newOne", "newTwo", "newThree", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
        this.dataView.addItemsBefore(Arrays.asList("newFour", "middle"), (Object)"middle");
        Assert.assertArrayEquals((Object[])new String[]{"newFour", "middle", "first", "newOne", "newTwo", "newThree", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
        this.dataView.addItemsBefore(Collections.singletonList("newFive"), (Object)"newFour");
        Assert.assertArrayEquals((Object[])new String[]{"newFive", "newFour", "middle", "first", "newOne", "newTwo", "newThree", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemsBefore_targetItemNotInCollection_throwsException() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("Item to insert before is not available in the data");
        this.dataView.addItemsBefore(Collections.singletonList("newItem"), (Object)"notExistent");
    }

    @Test
    public void addItemsBefore_nullCollectionPassed_throwsException() {
        this.exceptionRule.expect(NullPointerException.class);
        this.exceptionRule.expectMessage("Items collection cannot be null");
        this.dataView.addItemsBefore(null, (Object)"any");
    }

    @Test
    public void addItemsBefore_emptyCollectionPassed_dataNotChanged() {
        this.dataView.addItemsBefore(Collections.emptyList(), (Object)"any");
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemsBefore_addItemsInFilteredDataSet_itemsAddedBeforeTheTarget() {
        this.dataView.addFilter((SerializablePredicate & Serializable)item -> !item.equalsIgnoreCase("first"));
        this.dataView.addItemsBefore(Arrays.asList("newItem1", "newItem2"), (Object)"last");
        Assert.assertArrayEquals((Object[])new String[]{"middle", "newItem1", "newItem2", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void removeItems_itemsOutOfOrder_allItemsAreRemoved() {
        this.dataView.removeItems(Arrays.asList("middle", "first"));
        Assert.assertArrayEquals((Object[])new String[]{"last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void removeItems_nullCollectionPassed_throwsException() {
        this.exceptionRule.expect(NullPointerException.class);
        this.exceptionRule.expectMessage("Items collection cannot be null");
        this.dataView.removeItems(null);
    }

    @Test
    public void removeItems_emptyCollectionPassed_dataNotChanged() {
        this.dataView.removeItems(Collections.emptyList());
        Assert.assertArrayEquals((Object[])new String[]{"first", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void addItemsAndRemoveItems_noConcurrencyIssues() {
        this.dataView.addItemsBefore(Arrays.asList("newOne", "newTwo", "newThree"), (Object)"middle");
        Assert.assertArrayEquals((Object[])new String[]{"first", "newOne", "newTwo", "newThree", "middle", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
        this.dataView.removeItems(Arrays.asList("middle", "first"));
        Assert.assertArrayEquals((Object[])new String[]{"newOne", "newTwo", "newThree", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
        this.dataView.addItemsAfter(Arrays.asList("one", "two"), (Object)"newOne");
        Assert.assertArrayEquals((Object[])new String[]{"newOne", "one", "two", "newTwo", "newThree", "last"}, (Object[])this.dataView.getItems().toArray(String[]::new));
    }

    @Test
    public void dataProviderOnSet_exceptionThrownForAddItemBefore() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("DataProvider collection 'HashSet' is not a list.");
        HashSet<String> items = new HashSet<String>();
        items.add("item1");
        items.add("item2");
        ListDataProvider stringListDataProvider = new ListDataProvider(items);
        this.dataView = new ListDataViewImpl((SerializableSupplier & Serializable)() -> stringListDataProvider, this.component);
        this.dataView.addItemBefore((Object)"newItem", (Object)"item2");
    }

    @Test
    public void dataProviderOnSet_exceptionThrownForAddItemAfter() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("DataProvider collection 'HashSet' is not a list.");
        HashSet<String> items = new HashSet<String>();
        items.add("item1");
        items.add("item2");
        ListDataProvider stringListDataProvider = new ListDataProvider(items);
        this.dataView = new ListDataViewImpl((SerializableSupplier & Serializable)() -> stringListDataProvider, null);
        this.dataView.addItemAfter((Object)"newItem", (Object)"item1");
    }

    @Test
    public void dataProviderOnSet_exceptionThrownForAddItemsAfter() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("DataProvider collection 'HashSet' is not a list.");
        HashSet<String> items = new HashSet<String>();
        items.add("item1");
        items.add("item2");
        ListDataProvider stringListDataProvider = new ListDataProvider(items);
        this.dataView = new ListDataViewImpl((SerializableSupplier & Serializable)() -> stringListDataProvider, this.component);
        this.dataView.addItemsAfter(Collections.singleton("newItem"), (Object)"item1");
    }

    @Test
    public void dataProviderOnSet_exceptionThrownForAddItemsBefore() {
        this.exceptionRule.expect(IllegalArgumentException.class);
        this.exceptionRule.expectMessage("DataProvider collection 'HashSet' is not a list.");
        HashSet<String> items = new HashSet<String>();
        items.add("item1");
        items.add("item2");
        ListDataProvider stringListDataProvider = new ListDataProvider(items);
        this.dataView = new ListDataViewImpl((SerializableSupplier & Serializable)() -> stringListDataProvider, this.component);
        this.dataView.addItemsBefore(Collections.singleton("newItem"), (Object)"item1");
    }

    @Test
    public void addFilter_FilterIsAddedOnTop() {
        this.items = new ArrayList<String>(Arrays.asList("item1", "item2", "item22", "item3"));
        this.dataProvider = DataProvider.ofCollection(this.items);
        Assert.assertEquals((long)4L, (long)this.dataView.getItems().count());
        this.dataView.addFilter((SerializablePredicate & Serializable)item -> item.equals("item1") || item.equals("item2") || item.equals("item22"));
        Assert.assertEquals((long)3L, (long)this.dataView.getItems().count());
        this.dataView.addFilter((SerializablePredicate & Serializable)item -> item.endsWith("2"));
        Assert.assertEquals((long)2L, (long)this.dataView.getItems().count());
    }

    @Test
    public void removeFilters_removesAllSetAndAddedFilters() {
        this.items = new ArrayList<String>(Arrays.asList("item1", "item2", "item22", "item3"));
        this.dataProvider = DataProvider.ofCollection(this.items);
        this.dataView.setFilter((SerializablePredicate & Serializable)item -> item.endsWith("2") || item.endsWith("3"));
        Assert.assertEquals((String)"Set filter not applied", (long)3L, (long)this.dataView.getItems().count());
        this.dataView.addFilter((SerializablePredicate & Serializable)item -> item.endsWith("2"));
        Assert.assertEquals((String)"Added filter not applied", (long)2L, (long)this.dataView.getItems().count());
        this.dataView.removeFilters();
        Assert.assertEquals((String)"Filters were not cleared", (long)4L, (long)this.dataView.getItems().count());
    }

    @Test
    public void refreshItem_itemPresentInDataSet_refreshesItem() {
        Collection<Item> items = this.getTestItems();
        ListDataProvider dataProvider = (ListDataProvider)Mockito.spy((Object)DataProvider.ofCollection(items));
        ItemListDataView dataView = new ItemListDataView((SerializableSupplier & Serializable)() -> dataProvider, this.component);
        Iterator<Item> iterator = items.iterator();
        Item firstItem = iterator.next();
        firstItem.setValue("updatedValue");
        dataView.refreshItem(firstItem);
        ((ListDataProvider)Mockito.verify((Object)dataProvider)).refreshItem((Object)firstItem);
        dataView.setIdentifierProvider(Item::getId);
        Item secondItem = iterator.next();
        secondItem.setValue("updatedValue");
        Item secondItemDuplicate = new Item(2L);
        dataView.refreshItem(secondItemDuplicate);
        ((ListDataProvider)Mockito.verify((Object)dataProvider)).refreshItem((Object)secondItemDuplicate);
        ((ListDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).refreshItem((Object)secondItem);
    }

    @Test
    public void refreshItem_itemNotPresent_itemNotRefreshed() {
        Collection<Item> items = this.getTestItems();
        ListDataProvider dataProvider = (ListDataProvider)Mockito.spy((Object)DataProvider.ofCollection(items));
        ItemListDataView dataView = new ItemListDataView((SerializableSupplier & Serializable)() -> dataProvider, this.component);
        Item updatedItem = new Item(42L, "updated", "descr1");
        dataView.refreshItem(updatedItem);
        ((ListDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).refreshItem((Object)updatedItem);
        updatedItem = new Item(1L, "updated", "descr1");
        dataView.refreshItem(updatedItem);
        ((ListDataProvider)Mockito.verify((Object)dataProvider, (VerificationMode)Mockito.times((int)0))).refreshItem((Object)updatedItem);
    }

    @Test
    public void getItem_correctIndex_itemFound() {
        Assert.assertEquals((String)"Wrong item returned for index", (Object)"first", (Object)this.dataView.getItem(0));
    }

    @Test
    public void getItem_negativeIndex_throwsException() {
        this.exceptionRule.expect(IndexOutOfBoundsException.class);
        this.exceptionRule.expectMessage("Given index -1 is outside of the accepted range '0 - 2'");
        this.dataView.getItem(-1);
    }

    @Test
    public void getItem_emptyDataSet_throwsException() {
        this.dataProvider = DataProvider.ofItems((Object[])new String[0]);
        this.exceptionRule.expect(IndexOutOfBoundsException.class);
        this.exceptionRule.expectMessage("Requested index 0 on empty data.");
        this.dataView.getItem(0);
    }

    @Test
    public void getItem_filteringApplied_itemFound() {
        Assert.assertEquals((String)"Wrong item returned for index", (Object)"middle", (Object)this.dataView.getItem(1));
        this.dataProvider.setFilter((SerializablePredicate & Serializable)item -> "first".equals(item) || "last".equals(item));
        Assert.assertEquals((String)"Wrong item returned for index", (Object)"last", (Object)this.dataView.getItem(1));
    }

    @Test
    public void getItem_sortingApplied_itemFound() {
        Assert.assertEquals((String)"Wrong item returned for index", (Object)"first", (Object)this.dataView.getItem(0));
        this.dataProvider.setSortOrder((ValueProvider & Serializable)item -> item, SortDirection.DESCENDING);
        Assert.assertEquals((String)"Wrong item returned for index", (Object)"middle", (Object)this.dataView.getItem(0));
    }

    @Test
    public void getItem_indexOutsideOfSize_throwsException() {
        this.exceptionRule.expect(IndexOutOfBoundsException.class);
        this.dataView.getItem(this.items.size());
    }

    private Collection<Item> getTestItems() {
        return new ArrayList<Item>(Arrays.asList(new Item(1L, "value1", "descr1"), new Item(2L, "value2", "descr2"), new Item(3L, "value3", "descr3")));
    }

    private static /* synthetic */ DataProvider lambda$createListDataViewInstance_faultyDataProvider_throwsException$f9a249dc$1(DataProvider dataProvider) {
        return dataProvider;
    }

    @Tag(value="test-component")
    private static class TestComponent
    extends Component {
        private TestComponent() {
        }
    }

    private static class ItemListDataView
    extends AbstractListDataView<Item> {
        public ItemListDataView(SerializableSupplier<DataProvider<Item, ?>> dataProviderSupplier, Component component) {
            super(dataProviderSupplier, component);
        }
    }

    private static class ListDataViewImpl
    extends AbstractListDataView<String> {
        public ListDataViewImpl(SerializableSupplier<DataProvider<String, ?>> dataProviderSupplier, Component component) {
            super(dataProviderSupplier, component);
        }
    }
}

