/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.data.provider.CustomInMemoryDataProvider;
import com.vaadin.flow.data.provider.DataView;
import com.vaadin.flow.data.provider.HasDataView;
import com.vaadin.flow.data.provider.InMemoryDataProvider;
import com.vaadin.flow.data.provider.ItemCountChangeEvent;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractComponentDataViewTest {
    protected List<String> items;
    protected InMemoryDataProvider<String> dataProvider;
    protected DataView<String> dataView;
    protected HasDataView<String, Void, ? extends DataView<String>> component;

    @Before
    public void init() {
        this.items = new ArrayList<String>(Arrays.asList("first", "middle", "last"));
        this.dataProvider = new CustomInMemoryDataProvider<String>(this.items);
        this.component = this.getVerifiedComponent();
        this.dataView = this.component.setItems(this.dataProvider);
    }

    @Test
    public void getItems_noFiltersSet_allItemsObtained() {
        Stream allItems = this.dataView.getItems();
        Assert.assertArrayEquals((String)"Unexpected data set", (Object[])this.items.toArray(), (Object[])allItems.toArray());
    }

    @Test
    public void getItems_filtersSet_filteredItemsObtained() {
        this.dataProvider.setFilter((SerializablePredicate & Serializable)item -> item.equals("first"));
        Assert.assertArrayEquals((String)"Unexpected data set after filtering", (Object[])new String[]{"first"}, (Object[])this.dataView.getItems().toArray());
    }

    @Test
    public void getItems_sortingSet_sortedItemsObtained() {
        this.dataProvider.setSortComparator(String::compareToIgnoreCase);
        Assert.assertArrayEquals((String)"Unexpected items sorting", (Object[])new String[]{"first", "last", "middle"}, (Object[])this.dataView.getItems().toArray());
    }

    @Test
    public void addItemCountChangeListener_fireEvent_listenerNotified() {
        AtomicInteger fired = new AtomicInteger(0);
        this.dataView.addItemCountChangeListener((ComponentEventListener & Serializable)event -> fired.compareAndSet(0, event.getItemCount()));
        ComponentUtil.fireEvent((Component)((Component)this.component), (ComponentEvent)new ItemCountChangeEvent((Component)this.component, 10, false));
        Assert.assertEquals((long)10L, (long)fired.get());
    }

    protected abstract HasDataView<String, Void, ? extends DataView<String>> getComponent();

    private HasDataView<String, Void, ? extends DataView<String>> getVerifiedComponent() {
        HasDataView<String, Void, ? extends DataView<String>> component = this.getComponent();
        if (component instanceof Component) {
            return component;
        }
        throw new IllegalArgumentException(String.format("Component subclass is expected, but was given a '%s'", component.getClass().getSimpleName()));
    }

    protected static class Item {
        private long id;
        private String value;

        public Item(long id) {
            this.id = id;
        }

        public Item(long id, String value) {
            this.id = id;
            this.value = value;
        }

        public long getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public void setId(long id) {
            this.id = id;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            return this.id == item.id && Objects.equals(this.value, item.value);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

