/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.generator.registry;

import com.vaadin.flow.component.HasStyle;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExclusionRegistry {
    private static final Map<String, Set<String>> PROPERTY_EXCLUSION_REGISTRY = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> EVENT_EXCLUSION_REGISTRY = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> METHOD_EXCLUSION_REGISTRY = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> BEHAVIOR_EXCLUSION_REGISTRY = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> INTERFACE_EXCLUSION_REGISTRY = new HashMap<String, Set<String>>();

    private ExclusionRegistry() {
    }

    private static void put(String elementTag, String name, Map<String, Set<String>> map) {
        Objects.requireNonNull(name, "elementTag cannot be null.");
        map.computeIfAbsent(elementTag, element -> new HashSet()).add(name);
    }

    public static void excludeProperty(String elementTag, String propertyName) {
        ExclusionRegistry.put(elementTag, propertyName, PROPERTY_EXCLUSION_REGISTRY);
    }

    public static void excludeEvent(String elementTag, String eventName) {
        ExclusionRegistry.put(elementTag, eventName, EVENT_EXCLUSION_REGISTRY);
    }

    public static void excludeMethod(String elementTag, String methodName) {
        ExclusionRegistry.put(elementTag, methodName, METHOD_EXCLUSION_REGISTRY);
    }

    public static void excludeBehaviorOrMixin(String elementTag, String behaviorName) {
        ExclusionRegistry.put(elementTag, behaviorName, BEHAVIOR_EXCLUSION_REGISTRY);
    }

    public static void excludeInterface(String elementTag, Class<?> interfaceClass) {
        ExclusionRegistry.put(elementTag, interfaceClass.getName(), INTERFACE_EXCLUSION_REGISTRY);
    }

    private static boolean isExcluded(String elementTag, String name, Map<String, Set<String>> map) {
        if (map.getOrDefault(null, Collections.emptySet()).contains(name)) {
            return true;
        }
        return map.getOrDefault(elementTag, Collections.emptySet()).contains(name);
    }

    public static boolean isPropertyExcluded(String elementTag, String propertyName) {
        return ExclusionRegistry.isExcluded(elementTag, propertyName, PROPERTY_EXCLUSION_REGISTRY);
    }

    public static boolean isEventExcluded(String elementTag, String eventName) {
        return ExclusionRegistry.isExcluded(elementTag, eventName, EVENT_EXCLUSION_REGISTRY);
    }

    public static boolean isMethodExcluded(String elementTag, String methodName) {
        return ExclusionRegistry.isExcluded(elementTag, methodName, METHOD_EXCLUSION_REGISTRY);
    }

    public static boolean isBehaviorOrMixinExcluded(String elementTag, String behaviorName) {
        return ExclusionRegistry.isExcluded(elementTag, behaviorName, BEHAVIOR_EXCLUSION_REGISTRY);
    }

    public static boolean isInterfaceExcluded(String elementTag, Class<?> interfaceClass) {
        return ExclusionRegistry.isExcluded(elementTag, interfaceClass.getName(), INTERFACE_EXCLUSION_REGISTRY);
    }

    static {
        ExclusionRegistry.excludeProperty("vaadin-combo-box", "value");
        ExclusionRegistry.excludeProperty("vaadin-radio-group", "value");
        ExclusionRegistry.excludeProperty("vaadin-combo-box", "itemLabelPath");
        ExclusionRegistry.excludeProperty("vaadin-combo-box", "itemValuePath");
        ExclusionRegistry.excludeProperty("vaadin-tabs", "selected");
        ExclusionRegistry.excludeProperty("vaadin-tabs", "orientation");
        ExclusionRegistry.excludeProperty("vaadin-tabs", "items");
        ExclusionRegistry.excludeProperty("vaadin-text-field", "hasValue");
        ExclusionRegistry.excludeProperty("vaadin-text-area", "hasValue");
        ExclusionRegistry.excludeProperty("vaadin-dialog", "noCloseOnEsc");
        ExclusionRegistry.excludeProperty("vaadin-dialog", "noCloseOnOutsideClick");
        ExclusionRegistry.excludeProperty("vaadin-list-box", "selected");
        ExclusionRegistry.excludeProperty("vaadin-list-box", "items");
        ExclusionRegistry.excludeEvent("vaadin-combo-box", "change");
        ExclusionRegistry.excludeEvent("vaadin-combo-box", "valued-changed");
        ExclusionRegistry.excludeBehaviorOrMixin("vaadin-date-picker", "Polymer.GestureEventListeners");
        ExclusionRegistry.excludeInterface("vaadin-dialog", HasStyle.class);
        ExclusionRegistry.excludeInterface("vaadin-notification", HasStyle.class);
        ExclusionRegistry.excludeMethod(null, "connectedCallback");
        ExclusionRegistry.excludeMethod(null, "disconnectedCallback");
        ExclusionRegistry.excludeMethod(null, "attributeChangedCallback");
    }
}

