/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.generator;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

class JavaDocFormatter {
    private static final String JAVA_DOC_CODE_SECTION = "{@code $1}";
    private static final String JAVA_DOC_CODE_SECTION_MULTI = "{@code $2}";
    private static final String JAVA_DOC_CLOSE_ESCAPED = "&#42;&#47;";
    private static final Pattern MULTI_LINE_CODE_PARTS = Pattern.compile("```(js)?\\s*?(.*?)\\s*?```", 32);
    private static final Pattern MULTI_LINE_CODE_PARTS_HTML = Pattern.compile("```html\\s*(.*?)\\s*```", 32);
    private static final Pattern SINGLE_LINE_CODE_PARTS = Pattern.compile("`\\s*(.*?)\\s*`");
    private static final Pattern JAVA_DOC_CLOSE = Pattern.compile("\\*/");
    private final HtmlRenderer renderer;
    private final Parser parser;

    JavaDocFormatter() {
        List<Extension> extensions = Collections.singletonList(TablesExtension.create());
        this.parser = Parser.builder().extensions(extensions).build();
        this.renderer = HtmlRenderer.builder().extensions(extensions).build();
    }

    String formatJavaDoc(String javaDoc) {
        return this.postFormat(this.renderer.render(this.parser.parse(this.preFormat(javaDoc))));
    }

    private String preFormat(String javaDoc) {
        return String.format("%s%n%n%s", "Description copied from corresponding location in WebComponent:", this.replaceCodeParts(javaDoc));
    }

    private String postFormat(String javaDoc) {
        return this.escapeCommentCloseSign(javaDoc);
    }

    private String replaceCodeParts(String documentation) {
        return this.replaceByPattern(this.replaceByPattern(this.replaceHtml(documentation), MULTI_LINE_CODE_PARTS, JAVA_DOC_CODE_SECTION_MULTI), SINGLE_LINE_CODE_PARTS, JAVA_DOC_CODE_SECTION);
    }

    private String escapeCommentCloseSign(String documentation) {
        return this.replaceByPattern(documentation, JAVA_DOC_CLOSE, JAVA_DOC_CLOSE_ESCAPED);
    }

    private String replaceHtml(String documentation) {
        Matcher matcher = MULTI_LINE_CODE_PARTS_HTML.matcher(documentation);
        while (matcher.find()) {
            String html = matcher.group(1);
            html = StringEscapeUtils.escapeHtml4((String)html);
            documentation = documentation.replace(matcher.group(), html);
        }
        return documentation;
    }

    private String replaceByPattern(String original, Pattern pattern, String replacement) {
        return pattern.matcher(original).replaceAll(replacement);
    }
}

