/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.generator;

import com.vaadin.generator.metadata.ComponentFunctionData;
import com.vaadin.generator.metadata.ComponentFunctionParameterData;
import com.vaadin.generator.metadata.ComponentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class FunctionParameterVariantCombinator {
    private FunctionParameterVariantCombinator() {
    }

    public static Set<List<ComponentType>> generateVariants(ComponentFunctionData function) {
        if (function.getParameters() == null || function.getParameters().isEmpty()) {
            return Collections.singleton(Arrays.asList(new ComponentType[0]));
        }
        ArrayList<ComponentFunctionParameterData> parameterData = new ArrayList<ComponentFunctionParameterData>(function.getParameters());
        Set<List<ComponentType>> paramVariants = FunctionParameterVariantCombinator.generateCombinations((ComponentFunctionParameterData)parameterData.remove(0), parameterData);
        return paramVariants;
    }

    private static Set<List<ComponentType>> generateCombinations(ComponentFunctionParameterData paramData, List<ComponentFunctionParameterData> rest) {
        Comparator<List> listComparator = Comparator.comparing(Object::toString);
        if (rest.isEmpty()) {
            return FunctionParameterVariantCombinator.getTypeVariants(paramData).stream().map(xva$0 -> Arrays.asList(xva$0)).sorted(listComparator).collect(Collectors.toSet());
        }
        ArrayList<ComponentFunctionParameterData> copy = new ArrayList<ComponentFunctionParameterData>(rest);
        TreeSet<List<ComponentType>> ret = new TreeSet<List<ComponentType>>(listComparator);
        for (List<ComponentType> subCombinations : FunctionParameterVariantCombinator.generateCombinations((ComponentFunctionParameterData)copy.remove(0), copy)) {
            for (ComponentType typeVariants : FunctionParameterVariantCombinator.getTypeVariants(paramData)) {
                ArrayList<ComponentType> tmp = new ArrayList<ComponentType>(subCombinations);
                tmp.add(0, typeVariants);
                ret.add(tmp);
            }
        }
        return ret;
    }

    private static List<ComponentType> getTypeVariants(ComponentFunctionParameterData paramData) {
        ArrayList<ComponentType> typeVariants = new ArrayList<ComponentType>();
        if (paramData.getObjectType() != null) {
            paramData.getObjectType().forEach(typeVariants::add);
        }
        if (paramData.getType() != null) {
            paramData.getType().forEach(typeVariants::add);
        }
        typeVariants.sort(Comparator.comparing(Object::toString));
        return typeVariants;
    }
}

