/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis.util;

import com.twitter.finagle.Redis$;
import com.twitter.finagle.redis.Client;
import com.twitter.finagle.redis.util.ExternalRedis$;
import com.twitter.finagle.redis.util.RedisMode;
import com.twitter.finagle.redis.util.RedisMode$Cluster$;
import com.twitter.finagle.redis.util.RedisMode$Sentinel$;
import com.twitter.finagle.redis.util.RedisTestHelper$;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Range;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006[\u0001!\tA\f\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u001a\t\r]\u0002\u0001\u0015)\u00039\u0011\u0019\u0019\u0005\u0001)A\u0005\t\"9A\n\u0001a\u0001\n\u0003i\u0005bB+\u0001\u0001\u0004%\tA\u0016\u0005\u00079\u0002\u0001\u000b\u0015\u0002(\t\ru\u0003\u0001\u0015\"\u0003_\u0011\u0019y\u0006\u0001)C\u0005=\")\u0001\r\u0001C\tC\")Q\u000e\u0001C\u0001=\")a\u000e\u0001C\u0001=\")q\u000e\u0001C\u0001=\")\u0001\u000f\u0001C\u0001c\")a\u000f\u0001C\u0001o\u001eI\u00111\u0003\f\u0002\u0002#\u0005\u0011Q\u0003\u0004\t+Y\t\t\u0011#\u0001\u0002\u0018!1QF\u0005C\u0001\u00033A\u0011\"a\u0007\u0013#\u0003%\t!!\b\u0003\u001b\u0015CH/\u001a:oC2\u0014V\rZ5t\u0015\t9\u0002$\u0001\u0003vi&d'BA\r\u001b\u0003\u0015\u0011X\rZ5t\u0015\tYB$A\u0004gS:\fw\r\\3\u000b\u0005uq\u0012a\u0002;xSR$XM\u001d\u0006\u0002?\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0002\t5|G-\u001a\t\u0003U-j\u0011AF\u0005\u0003YY\u0011\u0011BU3eSNlu\u000eZ3\u0002\rqJg.\u001b;?)\ty\u0003\u0007\u0005\u0002+\u0001!9\u0001F\u0001I\u0001\u0002\u0004I\u0013\u0001\u0002:b]\u0012\u0004\"aM\u001b\u000e\u0003QR!a\u0006\u0013\n\u0005Y\"$A\u0002*b]\u0012|W.A\u0004qe>\u001cWm]:\u0011\u0007\rJ4(\u0003\u0002;I\t1q\n\u001d;j_:\u0004\"\u0001P!\u000e\u0003uR!AP \u0002\t1\fgn\u001a\u0006\u0002\u0001\u0006!!.\u0019<b\u0013\t\u0011UHA\u0004Qe>\u001cWm]:\u0002\u001bA|7o]5cY\u0016\u0004vN\u001d;t!\t)%*D\u0001G\u0015\t9\u0005*A\u0005j[6,H/\u00192mK*\u0011\u0011\nJ\u0001\u000bG>dG.Z2uS>t\u0017BA&G\u0005\u0015\u0011\u0016M\\4f\u0003\u001d\tG\r\u001a:fgN,\u0012A\u0014\t\u0004Gez\u0005C\u0001)T\u001b\u0005\t&B\u0001*@\u0003\rqW\r^\u0005\u0003)F\u0013\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0003-\tG\r\u001a:fgN|F%Z9\u0015\u0005]S\u0006CA\u0012Y\u0013\tIFE\u0001\u0003V]&$\bbB.\b\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\n\u0014\u0001C1eIJ,7o\u001d\u0011\u00021\u0005\u001c8/\u001a:u%\u0016$\u0017n\u001d\"j]\u0006\u0014\u0018\u0010\u0015:fg\u0016tG\u000fF\u0001X\u0003-1\u0017N\u001c3BI\u0012\u0014Xm]:\u0002!\r\u0014X-\u0019;f\u0007>tg-[4GS2,GC\u00012i!\t\u0019g-D\u0001e\u0015\t)w(\u0001\u0002j_&\u0011q\r\u001a\u0002\u0005\r&dW\rC\u0003j\u0017\u0001\u0007!.\u0001\u0003q_J$\bCA\u0012l\u0013\taGEA\u0002J]R\fQa\u001d;beR\fAa\u001d;pa\u00069!/Z:uCJ$\u0018!\u00038fo\u000ec\u0017.\u001a8u)\u0005\u0011\bCA:u\u001b\u0005A\u0012BA;\u0019\u0005\u0019\u0019E.[3oi\u0006Qq/\u001b;i\u00072LWM\u001c;\u0016\u0005a\\HcA=\u0002\nA\u0011!p\u001f\u0007\u0001\t\u0015a\bC1\u0001~\u0005\u0005!\u0016c\u0001@\u0002\u0004A\u00111e`\u0005\u0004\u0003\u0003!#a\u0002(pi\"Lgn\u001a\t\u0004G\u0005\u0015\u0011bAA\u0004I\t\u0019\u0011I\\=\t\u000f\u0005-\u0001\u00031\u0001\u0002\u000e\u0005\ta\rE\u0003$\u0003\u001f\u0011\u00180C\u0002\u0002\u0012\u0011\u0012\u0011BR;oGRLwN\\\u0019\u0002\u001b\u0015CH/\u001a:oC2\u0014V\rZ5t!\tQ#c\u0005\u0002\u0013EQ\u0011\u0011QC\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}!fA\u0015\u0002\"-\u0012\u00111\u0005\t\u0005\u0003K\ty#\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003%)hn\u00195fG.,GMC\u0002\u0002.\u0011\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t$a\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ExternalRedis {
    private final RedisMode mode;
    private final Random rand;
    private Option<Process> process;
    private final Range possiblePorts;
    private Option<InetSocketAddress> address;

    public static RedisMode $lessinit$greater$default$1() {
        return ExternalRedis$.MODULE$.$lessinit$greater$default$1();
    }

    public Option<InetSocketAddress> address() {
        return this.address;
    }

    public void address_$eq(Option<InetSocketAddress> x$1) {
        this.address = x$1;
    }

    private void assertRedisBinaryPresent() {
        Predef$.MODULE$.require(RedisTestHelper$.MODULE$.redisServerExists(), (Function0 & Serializable)() -> "redis-server binary must be present.");
    }

    private void findAddress() {
        int tries = this.possiblePorts.size() - 1;
        while (this.address().isEmpty() && tries >= 0) {
            InetSocketAddress addr = new InetSocketAddress(this.possiblePorts.apply(tries));
            try (Socket socket = new Socket();){
                try {
                    socket.setReuseAddress(true);
                    socket.bind(addr);
                    this.address_$eq((Option<InetSocketAddress>)new Some((Object)addr));
                }
                catch (Exception exc) {
                    this.address_$eq((Option<InetSocketAddress>)None$.MODULE$);
                    --tries;
                    Thread.sleep(5L);
                }
            }
        }
        this.address().getOrElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.error("Couldn't get an address for the external redis instance"));
    }

    /*
     * WARNING - void declaration
     */
    public File createConfigFile(int port) {
        void var2_2;
        File confFile = File.createTempFile(new StringBuilder(6).append("redis-").append(this.rand.nextInt(1000)).toString(), ".tmp");
        File nodesFile = File.createTempFile(new StringBuilder(12).append("redis-nodes-").append(this.rand.nextInt(1000)).toString(), ".tmp");
        File appendFile = File.createTempFile(new StringBuilder(13).append("redis-append-").append(this.rand.nextInt(1000)).toString(), ".aof");
        File dbFile = File.createTempFile(new StringBuilder(9).append("redis-db-").append(this.rand.nextInt(1000)).toString(), ".db");
        confFile.deleteOnExit();
        nodesFile.deleteOnExit();
        appendFile.deleteOnExit();
        dbFile.deleteOnExit();
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(confFile)));
        String conf = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("port %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)}));
        RedisMode redisMode = this.mode;
        RedisMode$Cluster$ redisMode$Cluster$ = RedisMode$Cluster$.MODULE$;
        if (!(redisMode != null ? !redisMode.equals(redisMode$Cluster$) : redisMode$Cluster$ != null)) {
            conf = new StringBuilder(0).append(conf).append(new StringBuilder(116).append("\ncluster-enabled yes\ncluster-config-file ").append(nodesFile.getAbsolutePath()).append("\ncluster-node-timeout 5000\nappendonly yes\ndir ").append(appendFile.getParent()).append("\nappendfilename ").append(appendFile.getName()).append("\ndbfilename ").append(dbFile.getName()).append("\n").toString()).toString();
        }
        out.write(conf);
        out.println();
        out.close();
        return var2_2;
    }

    public void start() {
        int port = ((InetSocketAddress)this.address().get()).getPort();
        String conf = this.createConfigFile(port).getAbsolutePath();
        RedisMode redisMode = this.mode;
        RedisMode$Sentinel$ redisMode$Sentinel$ = RedisMode$Sentinel$.MODULE$;
        scala.collection.immutable.Seq cmd = !(redisMode != null ? !redisMode.equals(redisMode$Sentinel$) : redisMode$Sentinel$ != null) ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"redis-server", conf, "--sentinel"})) : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"redis-server", conf}));
        ProcessBuilder builder = new ProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)cmd).asJava());
        this.process = new Some((Object)builder.start());
        Thread.sleep(200L);
    }

    public void stop() {
        this.process.foreach((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)ExternalRedis.$anonfun$stop$1(p)));
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public Client newClient() {
        return Redis$.MODULE$.newRichClient(new StringBuilder(10).append("127.0.0.1:").append(((InetSocketAddress)this.address().get()).getPort()).toString());
    }

    public <T> T withClient(Function1<Client, T> f) {
        Object object;
        try (Client client = this.newClient();){
            object = f.apply((Object)client);
        }
        return (T)object;
    }

    public static final /* synthetic */ int $anonfun$stop$1(Process p) {
        p.destroy();
        return p.waitFor();
    }

    public ExternalRedis(RedisMode mode) {
        this.mode = mode;
        this.rand = new Random();
        this.process = None$.MODULE$;
        this.possiblePorts = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(49152), 55535);
        this.address = None$.MODULE$;
        this.assertRedisBinaryPresent();
        this.findAddress();
    }
}

