/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.redis.protocol;

import com.twitter.finagle.redis.ServerError;
import com.twitter.finagle.redis.protocol.BulkReply;
import com.twitter.finagle.redis.protocol.EmptyBulkReply$;
import com.twitter.finagle.redis.protocol.EmptyMBulkReply$;
import com.twitter.finagle.redis.protocol.ErrorReply;
import com.twitter.finagle.redis.protocol.IntegerReply;
import com.twitter.finagle.redis.protocol.MBulkReply;
import com.twitter.finagle.redis.protocol.NilMBulkReply$;
import com.twitter.finagle.redis.protocol.Reply;
import com.twitter.finagle.redis.protocol.RequireServerProtocol$;
import com.twitter.finagle.redis.protocol.Stage;
import com.twitter.finagle.redis.protocol.Stage$;
import com.twitter.finagle.redis.protocol.StatusReply;
import com.twitter.io.Buf;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Reply$ {
    public static final Reply$ MODULE$ = new Reply$();
    private static final Buf EOL = Buf.Utf8$.MODULE$.apply("\r\n");
    private static final Buf STATUS_REPLY = Buf.Utf8$.MODULE$.apply("+");
    private static final Buf ERROR_REPLY = Buf.Utf8$.MODULE$.apply("-");
    private static final Buf INTEGER_REPLY = Buf.Utf8$.MODULE$.apply(":");
    private static final Buf BULK_REPLY = Buf.Utf8$.MODULE$.apply("$");
    private static final Buf MBULK_REPLY = Buf.Utf8$.MODULE$.apply("*");
    private static final Stage decodeStatus = Stage$.MODULE$.readLine((Function1<String, Stage.NextStep>)(Function1 & Serializable)line -> new Stage.NextStep.Emit(new StatusReply((String)line)));
    private static final Stage decodeError = Stage$.MODULE$.readLine((Function1<String, Stage.NextStep>)(Function1 & Serializable)line -> new Stage.NextStep.Emit(new ErrorReply((String)line)));
    private static final Stage decodeInteger = Stage$.MODULE$.readLine((Function1<String, Stage.NextStep>)(Function1 & Serializable)line -> (Stage.NextStep.Emit)RequireServerProtocol$.MODULE$.safe((Function0 & Serializable)() -> new Stage.NextStep.Emit(new IntegerReply(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(line))))));
    private static final Stage decodeBulk = Stage$.MODULE$.readLine((Function1<String, Stage.NextStep>)(Function1 & Serializable)line -> {
        int num = BoxesRunTime.unboxToInt(RequireServerProtocol$.MODULE$.safe((JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(line))));
        return num < 0 ? new Stage.NextStep.Emit(EmptyBulkReply$.MODULE$) : new Stage.NextStep.Goto(Stage$.MODULE$.readBytes(num, (Function1<Buf, Stage.NextStep>)(Function1 & Serializable)bytes -> new Stage.NextStep.Goto(Stage$.MODULE$.readBytes(2, (Function1<Buf, Stage.NextStep>)(Function1 & Serializable)x0$1 -> {
            Buf buf = x0$1;
            Buf buf2 = MODULE$.EOL();
            Buf buf3 = buf;
            if (buf2 != null ? !buf2.equals(buf3) : buf3 != null) {
                throw new ServerError("Expected EOL after line data and didn't find it");
            }
            Stage.NextStep.Emit emit = new Stage.NextStep.Emit(new BulkReply((Buf)bytes));
            return emit;
        }))));
    });
    private static final Stage decodeMBulk = Stage$.MODULE$.readLine((Function1<String, Stage.NextStep>)(Function1 & Serializable)line -> {
        long num = BoxesRunTime.unboxToLong(RequireServerProtocol$.MODULE$.safe((JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(line))));
        return num < 0L ? new Stage.NextStep.Emit(NilMBulkReply$.MODULE$) : (num == 0L ? new Stage.NextStep.Emit(EmptyMBulkReply$.MODULE$) : new Stage.NextStep.Accumulate(num, (Function1<List<Reply>, Reply>)(Function1 & Serializable)messages -> new MBulkReply((List<Reply>)messages)));
    });
    private static final Stage decode = Stage$.MODULE$.readBytes(1, (Function1<Buf, Stage.NextStep>)(Function1 & Serializable)x0$2 -> {
        Stage.NextStep.Goto goto_;
        Buf buf = x0$2;
        Buf buf2 = MODULE$.STATUS_REPLY();
        Buf buf3 = buf;
        if (!(buf2 != null ? !buf2.equals(buf3) : buf3 != null)) {
            goto_ = new Stage.NextStep.Goto(decodeStatus);
        } else {
            Buf buf4 = MODULE$.ERROR_REPLY();
            Buf buf5 = buf;
            if (!(buf4 != null ? !buf4.equals(buf5) : buf5 != null)) {
                goto_ = new Stage.NextStep.Goto(decodeError);
            } else {
                Buf buf6 = MODULE$.INTEGER_REPLY();
                Buf buf7 = buf;
                if (!(buf6 != null ? !buf6.equals(buf7) : buf7 != null)) {
                    goto_ = new Stage.NextStep.Goto(decodeInteger);
                } else {
                    Buf buf8 = MODULE$.BULK_REPLY();
                    Buf buf9 = buf;
                    if (!(buf8 != null ? !buf8.equals(buf9) : buf9 != null)) {
                        goto_ = new Stage.NextStep.Goto(decodeBulk);
                    } else {
                        Buf buf10 = MODULE$.MBULK_REPLY();
                        Buf buf11 = buf;
                        if (!(buf10 != null ? !buf10.equals(buf11) : buf11 != null)) {
                            goto_ = new Stage.NextStep.Goto(decodeMBulk);
                        } else {
                            Some some;
                            if (buf != null && !(some = Buf.Utf8$.MODULE$.unapply(buf)).isEmpty()) {
                                String rep = (String)some.get();
                                throw new ServerError(new StringBuilder(31).append("Unknown response format(").append(rep).append(") found").toString());
                            }
                            throw new MatchError((Object)buf);
                        }
                    }
                }
            }
        }
        return goto_;
    });

    public Buf EOL() {
        return EOL;
    }

    public Buf STATUS_REPLY() {
        return STATUS_REPLY;
    }

    public Buf ERROR_REPLY() {
        return ERROR_REPLY;
    }

    public Buf INTEGER_REPLY() {
        return INTEGER_REPLY;
    }

    public Buf BULK_REPLY() {
        return BULK_REPLY;
    }

    public Buf MBULK_REPLY() {
        return MBULK_REPLY;
    }

    public Stage decode() {
        return decode;
    }

    private Reply$() {
    }
}

