/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http;

import com.twitter.finagle.Stack;
import com.twitter.finagle.client.Transporter;
import com.twitter.finagle.http.param.AutomaticContinue;
import com.twitter.finagle.http.param.AutomaticContinue$;
import com.twitter.finagle.http.param.CompressionLevel;
import com.twitter.finagle.http.param.CompressionLevel$;
import com.twitter.finagle.http.param.Decompression;
import com.twitter.finagle.http.param.Decompression$;
import com.twitter.finagle.http.param.MaxHeaderSize;
import com.twitter.finagle.http.param.MaxHeaderSize$;
import com.twitter.finagle.http.param.MaxInitialLineSize;
import com.twitter.finagle.http.param.MaxInitialLineSize$;
import com.twitter.finagle.http.param.MaxRequestSize;
import com.twitter.finagle.http.param.MaxRequestSize$;
import com.twitter.finagle.http.param.MaxResponseSize;
import com.twitter.finagle.http.param.MaxResponseSize$;
import com.twitter.finagle.http.param.Streaming;
import com.twitter.finagle.http.param.Streaming$;
import com.twitter.finagle.netty4.Netty4Listener;
import com.twitter.finagle.netty4.Netty4Listener$;
import com.twitter.finagle.netty4.Netty4Transporter$;
import com.twitter.finagle.netty4.http.FinagleHttpObjectAggregator;
import com.twitter.finagle.netty4.http.TextualContentCompressor;
import com.twitter.finagle.netty4.http.handler.BadRequestHandler;
import com.twitter.finagle.netty4.http.handler.ClientExceptionMapper$;
import com.twitter.finagle.netty4.http.handler.FixedLengthMessageAggregator;
import com.twitter.finagle.netty4.http.handler.FixedLengthMessageAggregator$;
import com.twitter.finagle.netty4.http.handler.HeaderValidatorHandler$;
import com.twitter.finagle.netty4.http.handler.UnpoolHttpHandler$;
import com.twitter.finagle.netty4.http.handler.UriValidatorHandler$;
import com.twitter.finagle.netty4.http.package$;
import com.twitter.finagle.param.Logger$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.server.Listener;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.transport.TransportContext;
import com.twitter.util.StorageUnit;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import java.net.SocketAddress;
import java.util.logging.Logger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;

public final class package$ {
    public static final package$ MODULE$;
    private final String HttpCodecName;
    private final String Http2CodecName;
    private final String Http2MultiplexHandlerName;
    private final Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ClientPipelineInit;
    private final Function1<Stack.Params, Function1<SocketAddress, Transporter<Object, Object, TransportContext>>> Netty4HttpTransporter;
    private final Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ServerPipelineInit;
    private final Function1<Stack.Params, Listener<Object, Object, TransportContext>> Netty4HttpListener;

    static {
        new package$();
    }

    public String HttpCodecName() {
        return this.HttpCodecName;
    }

    public String Http2CodecName() {
        return this.Http2CodecName;
    }

    public String Http2MultiplexHandlerName() {
        return this.Http2MultiplexHandlerName;
    }

    public HttpClientCodec newHttpClientCodec(Stack.Params params) {
        StorageUnit maxInitialLineSize = ((MaxInitialLineSize)params.apply(MaxInitialLineSize$.MODULE$.maxInitialLineSizeParam())).size();
        StorageUnit maxHeaderSize = ((MaxHeaderSize)params.apply(MaxHeaderSize$.MODULE$.maxHeaderSizeParam())).size();
        return new HttpClientCodec((int)maxInitialLineSize.inBytes(), (int)maxHeaderSize.inBytes(), Integer.MAX_VALUE, false, false);
    }

    public HttpServerCodec newHttpServerCodec(Stack.Params params) {
        StorageUnit maxInitialLineSize = ((MaxInitialLineSize)params.apply(MaxInitialLineSize$.MODULE$.maxInitialLineSizeParam())).size();
        StorageUnit maxHeaderSize = ((MaxHeaderSize)params.apply(MaxHeaderSize$.MODULE$.maxHeaderSizeParam())).size();
        return new HttpServerCodec((int)maxInitialLineSize.inBytes(), (int)maxHeaderSize.inBytes(), Integer.MAX_VALUE, false);
    }

    public Function1<ChannelPipeline, BoxedUnit> initClientBefore(String role, Stack.Params params) {
        return new Serializable(role, params){
            public static final long serialVersionUID = 0L;
            public final String role$1;
            private final Stack.Params params$1;

            public final void apply(ChannelPipeline pipeline) {
                package$.MODULE$.initClientFn(this.params$1, (Function2<String, ChannelHandler, BoxedUnit>)new Serializable(this, pipeline){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.initClientBefore.1 $outer;
                    private final ChannelPipeline pipeline$1;

                    public final void apply(String x$1, ChannelHandler x$2) {
                        this.pipeline$1.addBefore(this.$outer.role$1, x$1, x$2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.pipeline$1 = pipeline$1;
                    }
                });
            }
            {
                this.role$1 = role$1;
                this.params$1 = params$1;
            }
        };
    }

    public Function1<ChannelPipeline, BoxedUnit> initClient(Stack.Params params) {
        return new Serializable(params){
            public static final long serialVersionUID = 0L;
            private final Stack.Params params$2;

            public final void apply(ChannelPipeline pipeline) {
                package$.MODULE$.initClientFn(this.params$2, (Function2<String, ChannelHandler, BoxedUnit>)new Serializable(this, pipeline){
                    public static final long serialVersionUID = 0L;
                    private final ChannelPipeline pipeline$2;

                    public final void apply(String x$3, ChannelHandler x$4) {
                        this.pipeline$2.addLast(x$3, x$4);
                    }
                    {
                        this.pipeline$2 = pipeline$2;
                    }
                });
            }
            {
                this.params$2 = params$2;
            }
        };
    }

    public void initClientFn(Stack.Params params, Function2<String, ChannelHandler, BoxedUnit> fn) {
        Streaming streaming;
        block4: {
            block3: {
                StorageUnit maxResponseSize;
                block2: {
                    maxResponseSize = ((MaxResponseSize)params.apply(MaxResponseSize$.MODULE$.maxResponseSizeParam())).size();
                    boolean decompressionEnabled = ((Decompression)params.apply(Decompression$.MODULE$.decompressionParam())).enabled();
                    Object object = decompressionEnabled ? fn.apply((Object)"httpDecompressor", (Object)new HttpContentDecompressor()) : BoxedUnit.UNIT;
                    streaming = (Streaming)params.apply(Streaming$.MODULE$.streamingParam());
                    if (!(streaming instanceof Streaming.Enabled)) break block2;
                    Streaming.Enabled enabled = (Streaming.Enabled)streaming;
                    StorageUnit fixedLengthStreamedAfter = enabled.fixedLengthStreamedAfter();
                    BoxedUnit boxedUnit = (BoxedUnit)fn.apply((Object)"fixedLenAggregator", (Object)new FixedLengthMessageAggregator(fixedLengthStreamedAfter, FixedLengthMessageAggregator$.MODULE$.$lessinit$greater$default$2()));
                    break block3;
                }
                if (!Streaming.Disabled$.MODULE$.equals(streaming)) break block4;
                BoxedUnit boxedUnit = (BoxedUnit)fn.apply((Object)"httpDechunker", (Object)new HttpObjectAggregator((int)maxResponseSize.inBytes()));
            }
            fn.apply((Object)HeaderValidatorHandler$.MODULE$.HandlerName(), (Object)HeaderValidatorHandler$.MODULE$);
            fn.apply((Object)"clientExceptionMapper", (Object)ClientExceptionMapper$.MODULE$);
            fn.apply((Object)"unpoolHttp", (Object)UnpoolHttpHandler$.MODULE$);
            return;
        }
        throw new MatchError((Object)streaming);
    }

    public Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ClientPipelineInit() {
        return this.ClientPipelineInit;
    }

    public Function1<Stack.Params, Function1<SocketAddress, Transporter<Object, Object, TransportContext>>> Netty4HttpTransporter() {
        return this.Netty4HttpTransporter;
    }

    public Function1<ChannelPipeline, BoxedUnit> initServer(Stack.Params params) {
        boolean autoContinue = ((AutomaticContinue)params.apply(AutomaticContinue$.MODULE$.automaticContinue())).enabled();
        StorageUnit maxRequestSize = ((MaxRequestSize)params.apply(MaxRequestSize$.MODULE$.maxRequestSizeParam())).size();
        boolean decompressionEnabled = ((Decompression)params.apply(Decompression$.MODULE$.decompressionParam())).enabled();
        int compressionLevel = ((CompressionLevel)params.apply(CompressionLevel$.MODULE$.compressionLevelParam())).level();
        Logger log = ((com.twitter.finagle.param.Logger)params.apply(Logger$.MODULE$.param())).log();
        StatsReceiver stats = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
        return new Serializable(params, autoContinue, maxRequestSize, decompressionEnabled, compressionLevel, stats){
            public static final long serialVersionUID = 0L;
            private final Stack.Params params$3;
            private final boolean autoContinue$1;
            private final StorageUnit maxRequestSize$1;
            private final boolean decompressionEnabled$1;
            private final int compressionLevel$1;
            private final StatsReceiver stats$1;

            public final void apply(ChannelPipeline pipeline) {
                Streaming streaming;
                block4: {
                    block3: {
                        ChannelPipeline channelPipeline;
                        block2: {
                            int n = this.compressionLevel$1;
                            Object object = n > 0 ? pipeline.addLast("httpCompressor", (ChannelHandler)new HttpContentCompressor(n)) : (-1 == n ? pipeline.addLast("httpCompressor", (ChannelHandler)new TextualContentCompressor()) : BoxedUnit.UNIT);
                            Object object2 = this.decompressionEnabled$1 ? pipeline.addLast("httpDecompressor", (ChannelHandler)new HttpContentDecompressor()) : BoxedUnit.UNIT;
                            streaming = (Streaming)this.params$3.apply(Streaming$.MODULE$.streamingParam());
                            if (!(streaming instanceof Streaming.Enabled)) break block2;
                            Streaming.Enabled enabled = (Streaming.Enabled)streaming;
                            StorageUnit fixedLengthStreamedAfter = enabled.fixedLengthStreamedAfter();
                            Object object3 = this.autoContinue$1 ? pipeline.addLast("expectContinue", (ChannelHandler)new HttpServerExpectContinueHandler()) : BoxedUnit.UNIT;
                            channelPipeline = pipeline.addLast("fixedLenAggregator", (ChannelHandler)new FixedLengthMessageAggregator(fixedLengthStreamedAfter, false));
                            break block3;
                        }
                        if (!Streaming.Disabled$.MODULE$.equals(streaming)) break block4;
                        channelPipeline = pipeline.addLast("httpDechunker", (ChannelHandler)new FinagleHttpObjectAggregator((int)this.maxRequestSize$1.inBytes(), this.autoContinue$1));
                    }
                    pipeline.addLast(UriValidatorHandler$.MODULE$.HandlerName(), (ChannelHandler)UriValidatorHandler$.MODULE$);
                    pipeline.addLast(HeaderValidatorHandler$.MODULE$.HandlerName(), (ChannelHandler)HeaderValidatorHandler$.MODULE$);
                    pipeline.addLast("badRequestHandler", (ChannelHandler)new BadRequestHandler(this.stats$1));
                    pipeline.addLast("unpoolHttp", (ChannelHandler)UnpoolHttpHandler$.MODULE$);
                    return;
                }
                throw new MatchError((Object)streaming);
            }
            {
                this.params$3 = params$3;
                this.autoContinue$1 = autoContinue$1;
                this.maxRequestSize$1 = maxRequestSize$1;
                this.decompressionEnabled$1 = decompressionEnabled$1;
                this.compressionLevel$1 = compressionLevel$1;
                this.stats$1 = stats$1;
            }
        };
    }

    public Function1<Stack.Params, Function1<ChannelPipeline, BoxedUnit>> ServerPipelineInit() {
        return this.ServerPipelineInit;
    }

    public Function1<Stack.Params, Listener<Object, Object, TransportContext>> Netty4HttpListener() {
        return this.Netty4HttpListener;
    }

    private package$() {
        MODULE$ = this;
        this.HttpCodecName = "httpCodec";
        this.Http2CodecName = "http2Codec";
        this.Http2MultiplexHandlerName = "Http2MultiplexHandler";
        this.ClientPipelineInit = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<ChannelPipeline, BoxedUnit> apply(Stack.Params params) {
                return new Serializable(this, params){
                    public static final long serialVersionUID = 0L;
                    private final Stack.Params params$4;

                    public final void apply(ChannelPipeline pipeline) {
                        pipeline.addLast(package$.MODULE$.HttpCodecName(), (ChannelHandler)package$.MODULE$.newHttpClientCodec(this.params$4));
                        package$.MODULE$.initClient(this.params$4).apply((Object)pipeline);
                    }
                    {
                        this.params$4 = params$4;
                    }
                };
            }
        };
        this.Netty4HttpTransporter = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<SocketAddress, Transporter<Object, Object, TransportContext>> apply(Stack.Params params) {
                return new Serializable(this, params){
                    public static final long serialVersionUID = 0L;
                    private final Stack.Params params$5;

                    public final Transporter<Object, Object, TransportContext> apply(SocketAddress addr) {
                        return Netty4Transporter$.MODULE$.raw((Function1)package$.MODULE$.ClientPipelineInit().apply((Object)this.params$5), addr, this.params$5, ManifestFactory$.MODULE$.Any());
                    }
                    {
                        this.params$5 = params$5;
                    }
                };
            }
        };
        this.ServerPipelineInit = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Function1<ChannelPipeline, BoxedUnit> apply(Stack.Params params) {
                return new Serializable(this, params){
                    public static final long serialVersionUID = 0L;
                    private final Stack.Params params$6;

                    public final void apply(ChannelPipeline pipeline) {
                        pipeline.addLast(package$.MODULE$.HttpCodecName(), (ChannelHandler)package$.MODULE$.newHttpServerCodec(this.params$6));
                        package$.MODULE$.initServer(this.params$6).apply((Object)pipeline);
                    }
                    {
                        this.params$6 = params$6;
                    }
                };
            }
        };
        this.Netty4HttpListener = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Netty4Listener<Object, Object, TransportContext> apply(Stack.Params params) {
                return Netty4Listener$.MODULE$.apply((Function1)package$.MODULE$.ServerPipelineInit().apply((Object)params), params, ManifestFactory$.MODULE$.Any(), ManifestFactory$.MODULE$.Any());
            }
        };
    }
}

