/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http.handler;

import com.twitter.finagle.http.BadRequestResponse$;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.headers.Rfc7230HeaderValidation;
import com.twitter.finagle.netty4.http.Bijections$finagle$;
import com.twitter.finagle.netty4.http.handler.BadRequestHandler$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.logging.Logger;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001i<Q!\u0001\u0002\t\n=\t\u0011CQ1e%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0004iC:$G.\u001a:\u000b\u0005\u00151\u0011\u0001\u00025uiBT!a\u0002\u0005\u0002\r9,G\u000f^=5\u0015\tI!\"A\u0004gS:\fw\r\\3\u000b\u0005-a\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001A\u0011\u0001#E\u0007\u0002\u0005\u0019)!C\u0001E\u0005'\t\t\")\u00193SKF,Xm\u001d;IC:$G.\u001a:\u0014\u0005E!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\rC\u0003\u001c#\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f!9a$\u0005b\u0001\n\u0003y\u0012a\u00017pOV\t\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$\u0015\u00059An\\4hS:<\u0017BA\u0013#\u0005\u0019aunZ4fe\"1q%\u0005Q\u0001\n\u0001\nA\u0001\\8hA\u0019)!C\u0001\u0001\u0007SM\u0011\u0001F\u000b\t\u0003WIj\u0011\u0001\f\u0006\u0003[9\nqa\u00195b]:,GN\u0003\u00020a\u0005)a.\u001a;us*\t\u0011'\u0001\u0002j_&\u00111\u0007\f\u0002\u001d\u0007\"\fgN\\3m\u0013:\u0014w.\u001e8e\u0011\u0006tG\r\\3s\u0003\u0012\f\u0007\u000f^3s\u0011!)\u0004F!A!\u0002\u00131\u0014!B:uCR\u001c\bCA\u001c:\u001b\u0005A$BA\u001b\t\u0013\tQ\u0004HA\u0007Ti\u0006$8OU3dK&4XM\u001d\u0005\u00067!\"\t\u0001\u0010\u000b\u0003{y\u0002\"\u0001\u0005\u0015\t\u000bUZ\u0004\u0019\u0001\u001c\t\r\u0001C\u0003\u0015!\u0003B\u0003IIgN^1mS\u0012DU-\u00193fe:\u000bW.Z:\u0011\u0005]\u0012\u0015BA\"9\u0005\u001d\u0019u.\u001e8uKJDa!\u0012\u0015!\u0002\u0013\t\u0015aE5om\u0006d\u0017\u000e\u001a%fC\u0012,'OV1mk\u0016\u001c\b\"B$)\t\u0003B\u0015aC2iC:tW\r\u001c*fC\u0012$2!\u0013'R!\t)\"*\u0003\u0002L-\t!QK\\5u\u0011\u0015ie\t1\u0001O\u0003\r\u0019G\u000f\u001f\t\u0003W=K!\u0001\u0015\u0017\u0003+\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\u000e{g\u000e^3yi\")!K\u0012a\u0001'\u0006\u0019Qn]4\u0011\u0005U!\u0016BA+\u0017\u0005\r\te.\u001f\u0005\u0007/\"\u0002K\u0011\u0002-\u0002'!\fg\u000e\u001a7f\t\u0016\u001cw\u000eZ3GC&dWO]3\u0015\u0007%K&\fC\u0003N-\u0002\u0007a\nC\u0003\\-\u0002\u0007A,A\u0002pE*\u0004\"!\u00182\u000e\u0003yS!!B0\u000b\u0005\u0001\f\u0017!B2pI\u0016\u001c'BA\u0002/\u0013\t\u0019gL\u0001\u0006IiR\u0004xJ\u00196fGRDa!\u001a\u0015!\n\u00131\u0017aE3yG\u0016\u0004H/[8o)>\u0014Vm\u001d9p]N,GCA4m!\tA'.D\u0001j\u0015\t)\u0001\"\u0003\u0002lS\nA!+Z:q_:\u001cX\rC\u0003nI\u0002\u0007a.\u0001\u0002fqB\u0011qn\u001e\b\u0003aVt!!\u001d;\u000e\u0003IT!a\u001d\b\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012B\u0001<\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001_=\u0003\u0013QC'o\\<bE2,'B\u0001<\u0017\u0001")
public class BadRequestHandler
extends ChannelInboundHandlerAdapter {
    private final Counter invalidHeaderNames;
    private final Counter invalidHeaderValues;

    public static Logger log() {
        return BadRequestHandler$.MODULE$.log();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        HttpObject httpObject;
        Object object = msg;
        if (object instanceof HttpObject && (httpObject = (HttpObject)object).decoderResult().isFailure()) {
            ReferenceCountUtil.release((Object)httpObject);
            this.handleDecodeFailure(ctx, httpObject);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ctx.fireChannelRead(msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void handleDecodeFailure(ChannelHandlerContext ctx, HttpObject obj) {
        HttpObject httpObject = obj;
        if (httpObject instanceof HttpMessage) {
            Throwable failure = obj.decoderResult().cause();
            Response resp = this.exceptionToResponse(failure);
            FullHttpResponse nettyResp = Bijections$finagle$.MODULE$.fullResponseToNetty(resp);
            Throwable throwable = failure;
            if (throwable instanceof Rfc7230HeaderValidation.NameValidationException) {
                this.invalidHeaderNames.incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (throwable instanceof Rfc7230HeaderValidation.ValueValidationException) {
                this.invalidHeaderValues.incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            ctx.writeAndFlush((Object)nettyResp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BadRequestHandler$.MODULE$.log().debug("Detected invalid trailing headers in the HTTP stream. Tearing down the connection.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            ctx.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Response exceptionToResponse(Throwable ex) {
        TooLongFrameException tooLongFrameException;
        Throwable throwable = ex;
        Response response = throwable instanceof TooLongFrameException ? ((tooLongFrameException = (TooLongFrameException)throwable).getMessage().startsWith("An HTTP line is larger than ") ? BadRequestResponse$.MODULE$.uriTooLong() : BadRequestResponse$.MODULE$.headerTooLong()) : BadRequestResponse$.MODULE$.apply();
        return response;
    }

    public BadRequestHandler(StatsReceiver stats) {
        this.invalidHeaderNames = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rejected_invalid_header_names"}));
        this.invalidHeaderValues = stats.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rejected_invalid_header_values"}));
    }
}

