/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty4.http;

import com.twitter.finagle.http.Chunk;
import com.twitter.finagle.http.Chunk$;
import com.twitter.finagle.http.FileElement;
import com.twitter.finagle.http.FormElement;
import com.twitter.finagle.http.MediaType$;
import com.twitter.finagle.http.Method$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.RequestConfig;
import com.twitter.finagle.http.RequestConfig$;
import com.twitter.finagle.http.SimpleElement;
import com.twitter.finagle.http.exp.FormPostEncoder;
import com.twitter.finagle.netty4.ByteBufConversion$;
import com.twitter.finagle.netty4.http.Bijections$finagle$;
import com.twitter.finagle.netty4.http.Bijections$netty$;
import com.twitter.finagle.netty4.http.Netty4FormPostEncoder$;
import com.twitter.io.Buf;
import com.twitter.io.Reader;
import com.twitter.io.Reader$;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Netty4FormPostEncoder$
implements FormPostEncoder {
    public static final Netty4FormPostEncoder$ MODULE$;
    private final String BinaryTransferEncodingMechanism;
    private final String SevenBitTransferEncodingMechanism;

    static {
        new Netty4FormPostEncoder$();
    }

    private HttpRequest makeNetty4Request(RequestConfig config) {
        HttpVersion version = Bijections$finagle$.MODULE$.versionToNetty(config.version());
        HttpMethod method = Bijections$finagle$.MODULE$.methodToNetty(Method$.MODULE$.Post());
        String uri = RequestConfig$.MODULE$.resource(config);
        DefaultHttpRequest request = new DefaultHttpRequest(version, method, uri);
        config.headers().foreach((Function1)new Serializable(request){
            public static final long serialVersionUID = 0L;
            public final DefaultHttpRequest request$1;

            public final void apply(Tuple2<String, Seq<String>> x0$1) {
                Tuple2<String, Seq<String>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String field = (String)tuple2._1();
                    Seq values = (Seq)tuple2._2();
                    values.foreach((Function1)new Serializable(this, field){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.makeNetty4Request.1 $outer;
                        private final String field$1;

                        public final HttpHeaders apply(String v) {
                            return this.$outer.request$1.headers().add(this.field$1, (Object)v);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.field$1 = field$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.request$1 = request$1;
            }
        });
        return request;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Request encode(RequestConfig config, boolean multipart) {
        Request request;
        DefaultHttpDataFactory dataFactory = new DefaultHttpDataFactory(false);
        HttpRequest netty4Request = this.makeNetty4Request(config);
        if (netty4Request instanceof FullHttpRequest) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected state: Expected the generated request to NOT"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"be a full request: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{netty4Request.getClass().getSimpleName()}))).toString());
        }
        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((HttpDataFactory)dataFactory, netty4Request, multipart);
        try {
            Request request2;
            BoxedUnit boxedUnit;
            config.formElements().foreach((Function1)new Serializable(dataFactory, netty4Request, encoder){
                public static final long serialVersionUID = 0L;
                private final DefaultHttpDataFactory dataFactory$1;
                private final HttpRequest netty4Request$1;
                private final HttpPostRequestEncoder encoder$1;

                public final void apply(FormElement x0$2) {
                    FormElement formElement;
                    block4: {
                        block3: {
                            block2: {
                                formElement = x0$2;
                                if (!(formElement instanceof FileElement)) break block2;
                                FileElement fileElement = (FileElement)formElement;
                                String name = fileElement.name();
                                Buf content = fileElement.content();
                                Option contentType = fileElement.contentType();
                                Option filename = fileElement.filename();
                                Netty4FormPostEncoder$.MODULE$.com$twitter$finagle$netty4$http$Netty4FormPostEncoder$$addBodyFileUpload(this.encoder$1, (HttpDataFactory)this.dataFactory$1, this.netty4Request$1, name, (String)filename.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }), content, (String)contentType.orNull(Predef$.MODULE$.$conforms()), false);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(formElement instanceof SimpleElement)) break block4;
                            SimpleElement simpleElement = (SimpleElement)formElement;
                            String name = simpleElement.name();
                            String value = simpleElement.content();
                            this.encoder$1.addBodyAttribute(name, value);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError((Object)formElement);
                }
                {
                    this.dataFactory$1 = dataFactory$1;
                    this.netty4Request$1 = netty4Request$1;
                    this.encoder$1 = encoder$1;
                }
            });
            HttpRequest encodedReq = encoder.finalizeRequest();
            if (HttpUtil.isTransferEncodingChunked((HttpMessage)encodedReq)) {
                List encodings = encodedReq.headers().getAll("Transfer-Encoding");
                if (encodings.contains("chunked")) {
                    if (encodings.size() == 1) {
                        boxedUnit = encodedReq.headers().remove("Transfer-Encoding");
                    } else {
                        ArrayList<String> newList = new ArrayList<String>(encodings.size() - 1);
                        for (String string : encodings) {
                            if ("chunked".equals(string)) {
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                continue;
                            }
                            Boolean bl = BoxesRunTime.boxToBoolean((boolean)newList.add(string));
                        }
                        boxedUnit = encodedReq.headers().set("Transfer-Encoding", newList);
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            HttpRequest httpRequest = encodedReq;
            if (httpRequest instanceof FullHttpRequest) {
                FullHttpRequest fullHttpRequest = (FullHttpRequest)httpRequest;
                Request req = Bijections$netty$.MODULE$.fullRequestToFinagle(fullHttpRequest, new InetSocketAddress(0));
                Option option = req.contentLength();
                if (None$.MODULE$.equals(option)) {
                    req.contentLength_$eq((long)req.content().length());
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    if (!(option instanceof Some)) throw new MatchError((Object)option);
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                }
                request2 = req;
            } else {
                Buf body = this.collectBodyFromEncoder(encoder);
                request2 = this.chunkedReqToFinagle(httpRequest, body);
            }
            request = request2;
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        encoder.close();
        return request;
    }

    /*
     * WARNING - void declaration
     */
    private Request chunkedReqToFinagle(HttpRequest nettyReq, Buf body) {
        void var3_3;
        Request req = Bijections$netty$.MODULE$.chunkedRequestToFinagle(nettyReq, (Reader<Chunk>)Reader$.MODULE$.value((Object)Chunk$.MODULE$.apply(body)), new InetSocketAddress(0));
        req.setChunked(false);
        req.content_$eq(body);
        req.contentLength_$eq((long)body.length());
        return var3_3;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private Buf collectBodyFromEncoder(HttpPostRequestEncoder encoder) {
        void var3_3;
        Buf buf;
        UnpooledByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;
        CompositeByteBuf acc = PooledByteBufAllocator.DEFAULT.compositeHeapBuffer(Integer.MAX_VALUE);
        while (true) {
            if (!encoder.isEndOfInput()) break block4;
            byte[] arr = new byte[acc.readableBytes()];
            acc.readBytes(arr);
            buf = Buf.ByteArray$.Owned$.MODULE$.apply(arr);
            break;
        }
        catch (Throwable throwable) {
            var3_3.release();
            throw throwable;
        }
        {
            void var2_2;
            block4: {
                acc.release();
                return buf;
            }
            HttpContent chunk = encoder.readChunk((ByteBufAllocator)var2_2);
            var3_3.addComponent(true, chunk.content());
            continue;
        }
    }

    public void com$twitter$finagle$netty4$http$Netty4FormPostEncoder$$addBodyFileUpload(HttpPostRequestEncoder encoder, HttpDataFactory factory, HttpRequest request, String name, String filename, Buf content, String contentType, boolean isText) {
        Predef$.MODULE$.require(name != null);
        Predef$.MODULE$.require(filename != null);
        Predef$.MODULE$.require(content != null);
        String uploadContentType = contentType == null ? (isText ? MediaType$.MODULE$.PlainText() : MediaType$.MODULE$.OctetStream()) : contentType;
        String contentTransferEncoding = isText ? this.SevenBitTransferEncodingMechanism() : this.BinaryTransferEncodingMechanism();
        FileUpload fileUpload = factory.createFileUpload(request, name, filename, uploadContentType, contentTransferEncoding, null, (long)content.length());
        fileUpload.setContent(ByteBufConversion$.MODULE$.bufAsByteBuf(content));
        encoder.addBodyHttpData((InterfaceHttpData)fileUpload);
    }

    private String BinaryTransferEncodingMechanism() {
        return this.BinaryTransferEncodingMechanism;
    }

    private String SevenBitTransferEncodingMechanism() {
        return this.SevenBitTransferEncodingMechanism;
    }

    private Netty4FormPostEncoder$() {
        MODULE$ = this;
        this.BinaryTransferEncodingMechanism = "binary";
        this.SevenBitTransferEncodingMechanism = "7bit";
    }
}

