/*
 * haxe-import-csv
 * Copyright 2014 深圳岂凡网络有限公司 (Shenzhen QiFun Network Corp., LTD)
 *
 * Author: 杨博 (Yang Bo) <pop.atry@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package importCsv.error ;

class CsvParserError
{

  @:allow(importCsv.CsvParser)
  function new(positionMin:Int, positionMax:Int)
  {
    this.positionMin = positionMin;
    this.positionMax = positionMax;
  }

  public var positionMin(default, null):Int;

  public var positionMax(default, null):Int;

  public var message(get, never):String;

  function get_message() return "CSV parser error";

}

@:final
class UnexpectedEof extends CsvParserError
{

  override function get_message() return "Unexpected <end of file>";

}

@:final
class UnexpectedCell extends CsvParserError
{

  override function get_message() return "Expected CRLF or \",\"";

}
