/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.optimisticconcurrency;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class Main {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            String uri = args[1];
            if (args[0].equalsIgnoreCase("GET")) {
                byte[] content = Main.get(uri);
                System.out.println(new String(content));
                return;
            } else if (args[0].equalsIgnoreCase("DELETE")) {
                Main.delete(uri);
                return;
            } else {
                if (!args[0].equalsIgnoreCase("PUT")) throw new IllegalArgumentException();
                Main.put(uri);
            }
            return;
        } else if (args.length == 3) {
            String uri = args[1];
            if (!args[0].equalsIgnoreCase("PUT")) throw new IllegalArgumentException();
            Main.put(uri, args[2], new BufferedInputStream(System.in));
            return;
        } else {
            if (args.length != 4) throw new IllegalArgumentException();
            String uri = args[1];
            if (!args[0].equalsIgnoreCase("PUT")) throw new IllegalArgumentException();
            Main.put(uri, args[2], new BufferedInputStream(new FileInputStream(args[3])));
        }
    }

    private void printUsage() {
    }

    private static byte[] get(String uri) throws IOException {
        int r;
        URL u = new URL(uri);
        HttpURLConnection uc = (HttpURLConnection)u.openConnection();
        uc.setRequestMethod("GET");
        int status = uc.getResponseCode();
        String mediaType = uc.getContentType();
        InputStream in = uc.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((r = in.read(buffer)) != -1) {
            baos.write(buffer, 0, r);
        }
        return baos.toByteArray();
    }

    private static void put(String uri) throws IOException {
        URL u = new URL(uri);
        HttpURLConnection uc = (HttpURLConnection)u.openConnection();
        uc.setRequestMethod("PUT");
        int status = uc.getResponseCode();
        System.out.println("Status: " + status);
    }

    private static void put(String uri, String mediaType, InputStream in) throws IOException {
        int read;
        URL u = new URL(uri);
        HttpURLConnection uc = (HttpURLConnection)u.openConnection();
        uc.setRequestMethod("PUT");
        uc.setRequestProperty("Content-Type", mediaType);
        uc.setDoOutput(true);
        OutputStream out = uc.getOutputStream();
        byte[] data = new byte[2048];
        while ((read = in.read(data)) != -1) {
            out.write(data, 0, read);
        }
        out.close();
        int status = uc.getResponseCode();
        System.out.println("Status: " + status);
    }

    private static void delete(String uri) throws IOException {
        URL u = new URL(uri);
        HttpURLConnection uc = (HttpURLConnection)u.openConnection();
        uc.setRequestMethod("DELETE");
        int status = uc.getResponseCode();
        System.out.println("Status: " + status);
    }
}

