/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.spi.container.embedded.glassfish;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.WebAppDescriptor;
import com.sun.jersey.test.framework.impl.container.embedded.glassfish.WebXmlGenerator;
import com.sun.jersey.test.framework.spi.container.TestContainer;
import com.sun.jersey.test.framework.spi.container.TestContainerException;
import com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.JAXBException;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.archive.ScatteredArchive;

public class EmbeddedGlassFishTestContainerFactory
implements TestContainerFactory {
    public Class<WebAppDescriptor> supports() {
        return WebAppDescriptor.class;
    }

    public TestContainer create(URI baseUri, AppDescriptor ad) {
        if (!(ad instanceof WebAppDescriptor)) {
            throw new IllegalArgumentException("The application descriptor must be an instance of WebAppDescriptor");
        }
        return new EmbeddedGlassFishTestContainer(baseUri, (WebAppDescriptor)ad);
    }

    private static class EmbeddedGlassFishTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(EmbeddedGlassFishTestContainer.class.getName());
        private ScatteredArchive warArchive;
        private GlassFish glassfish;
        private GlassFishRuntime gfr;
        private WebAppDescriptor appDescriptor;
        final URI baseUri;
        final String WEB_XML = "web.xml";
        final String SUN_WEB_XML = "sun-web.xml";
        final String WEB_INF_PATH = "WEB-INF";
        final String TARGET_WEBAPP_PATH = "target/webapp";
        final String SRC_WEBAPP_PATH = "src/main/webapp";
        final String TARGET_CLASSES_PATH = "target/classes";
        final String TARGET_PATH = "target";
        final String CLASSES_PATH = "classes";

        private EmbeddedGlassFishTestContainer(URI baseUri, WebAppDescriptor ad) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).path(ad.getContextPath()).path(ad.getServletPath()).build(new Object[0]);
            this.appDescriptor = ad;
            LOGGER.info("Creating EmbeddedGlassFish test container configured at the base URI " + this.baseUri);
            this.instantiateServer();
            this.createArchive();
        }

        public Client getClient() {
            return null;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        private void copyFile(FileInputStream fin, FileOutputStream fout) {
            try {
                int i;
                do {
                    if ((i = fin.read()) == -1) continue;
                    fout.write(i);
                } while (i != -1);
                fin.close();
                fout.close();
            }
            catch (IOException ioeX) {
                LOGGER.info("Encountered IOException [" + ioeX.getMessage() + "] trying to copyFile(InputStream,OutputStream) for [" + this.warArchive.toString() + "]");
                throw new TestContainerException((Throwable)ioeX);
            }
        }

        public void start() {
            LOGGER.info("Starting the EmbeddedGlassFish instance...");
            try {
                this.glassfish.start();
                Deployer deployer = this.glassfish.getDeployer();
                if (this.warArchive == null) {
                    LOGGER.info("warArchive is null, nothing deployed");
                } else {
                    LOGGER.info("About to deploy [" + this.warArchive.toURI().toString() + "] from path [" + this.warArchive.toURI().getPath() + "]  to EmbeddedGlassFish instance [" + deployer.toString() + "] with context-root set to [" + this.appDescriptor.getContextPath() + "]");
                    String deployedApp = deployer.deploy(this.warArchive.toURI(), new String[0]);
                    LOGGER.info("Deployed [" + deployedApp + "] to EmbeddedGlassFish instance [" + deployer.toString() + "] with context-root set to [" + this.appDescriptor.getContextPath() + "]");
                }
            }
            catch (GlassFishException ex) {
                LOGGER.info("Caught GlassFishException [" + ex.getMessage() + "] trying to start the embedded server instance");
                throw new TestContainerException((Throwable)ex);
            }
            catch (IOException ioe) {
                LOGGER.info("Caught IOException [" + ioe.getMessage() + "] trying to start the embedded server instance");
                throw new TestContainerException((Throwable)ioe);
            }
        }

        private void undeployAllApplications() {
            Collection deployedApps;
            Deployer deployer;
            try {
                deployer = this.glassfish.getDeployer();
                deployedApps = deployer.getDeployedApplications();
            }
            catch (GlassFishException glassFishException) {
                throw new TestContainerException((Throwable)glassFishException);
            }
            for (String deployedApp : deployedApps) {
                try {
                    deployer.undeploy(deployedApp, new String[]{"--droptables", "true"});
                }
                catch (GlassFishException glassFishException) {
                    throw new TestContainerException((Throwable)glassFishException);
                }
                LOGGER.info("Undeployed = " + deployedApp);
            }
        }

        public void stop() {
            LOGGER.info("Stopping the EmbeddedGlassFish instance...");
            try {
                this.undeployAllApplications();
                this.gfr.shutdown();
            }
            catch (GlassFishException ex) {
                throw new TestContainerException((Throwable)ex);
            }
        }

        private void instantiateServer() {
            if (this.gfr == null) {
                try {
                    LOGGER.info("Create instantiated GlassFishRuntime");
                    this.gfr = GlassFishRuntime.bootstrap();
                }
                catch (GlassFishException ex) {
                    throw new TestContainerException((Throwable)ex);
                }
            }
            LOGGER.info("Re-use Already instantiated GlassFishRuntime");
            try {
                this.gfr.shutdown();
                this.gfr = GlassFishRuntime.bootstrap();
            }
            catch (GlassFishException shutdownex) {
                throw new TestContainerException((Throwable)shutdownex);
            }
            if (this.glassfish == null) {
                try {
                    GlassFishProperties gfProperties = new GlassFishProperties();
                    gfProperties.setPort("http-listener", this.getBaseUri().getPort());
                    this.glassfish = this.gfr.newGlassFish(gfProperties);
                }
                catch (GlassFishException ngfex) {
                    throw new TestContainerException((Throwable)ngfex);
                }
            }
            LOGGER.info("Dispose Already instantiated GlassFish");
            try {
                this.glassfish.dispose();
            }
            catch (GlassFishException disposeex) {
                throw new TestContainerException((Throwable)disposeex);
            }
            LOGGER.info("Create another instantiated GlassFish");
            try {
                this.glassfish = this.gfr.newGlassFish();
            }
            catch (GlassFishException ngfex2) {
                throw new TestContainerException((Throwable)ngfex2);
            }
        }

        private boolean webXmlGeneratedOnTheFly() {
            if (!this.webXmlExists()) {
                File webXmlDir = new File("target/webapp/WEB-INF");
                webXmlDir.mkdirs();
                File webXml = new File("target/webapp/WEB-INF/web.xml");
                try {
                    FileOutputStream outputStream = new FileOutputStream(webXml);
                    WebXmlGenerator webXmlGenerator = new WebXmlGenerator(this.appDescriptor);
                    try {
                        webXmlGenerator.marshalData(outputStream);
                    }
                    catch (JAXBException ex) {
                        throw new TestContainerException((Throwable)ex);
                    }
                    ((OutputStream)outputStream).close();
                }
                catch (FileNotFoundException ex) {
                    throw new TestContainerException((Throwable)ex);
                }
                catch (IOException ex) {
                    throw new TestContainerException((Throwable)ex);
                }
                return true;
            }
            return false;
        }

        private boolean webXmlExists() {
            File webXml = new File("src/main/webapp/WEB-INF/web.xml");
            return webXml.exists();
        }

        private boolean sunWebXmlExists() {
            File sunWebXml = new File("src/main/webapp/WEB-INF/sun-web.xml");
            return sunWebXml.exists();
        }

        private void createArchive() {
            if (!this.webXmlGeneratedOnTheFly()) {
                try {
                    LOGGER.info("#1 inside method createArchive ==> webXmlGeneratedOnTheFly ==> Creating scatteredArchive [src/main/webapp]");
                    this.warArchive = new ScatteredArchive(this.baseUri.getRawPath(), ScatteredArchive.Type.WAR);
                    try {
                        this.warArchive.addMetadata(new File("src/main/webapp/WEB-INF/", "web.xml"));
                    }
                    catch (IOException ioe) {
                        LOGGER.info("Encountered IOException [" + ioe.getMessage() + "] trying to addMetadata [" + "src/main/webapp" + "/" + "WEB-INF" + "/" + "web.xml" + "]");
                        throw new TestContainerException((Throwable)ioe);
                    }
                    try {
                        this.warArchive.addMetadata(new File("src/main/webapp/WEB-INF/", "sun-web.xml"));
                    }
                    catch (IOException ioe) {
                        LOGGER.info("Encountered IOException [" + ioe.getMessage() + "] trying to addMetadata [" + "sun-web.xml" + "]");
                        throw new TestContainerException((Throwable)ioe);
                    }
                    try {
                        this.warArchive.addClassPath(new File("target", "classes"));
                    }
                    catch (IOException ioe) {
                        LOGGER.info("Encountered IOException [" + ioe.getMessage() + "] trying to addClassPath [" + "target" + "/" + "classes" + "]");
                        throw new TestContainerException((Throwable)ioe);
                    }
                    LOGGER.info("#1 inside method createArchive ==> webXmlGeneratedOnTheFly ==> just created scatteredArchive [src/main/webapp] using WEB-INF/web.xml from [" + this.warArchive.toString() + "]");
                    System.out.println("jsb, #1 inside method createArchive ==> webXmlGeneratedOnTheFly ==> just created scatteredArchive [src/main/webapp] using WEB-INF/web.xml from [" + this.warArchive.toString() + "]");
                }
                catch (Exception ex) {
                    throw new TestContainerException((Throwable)ex);
                }
            }
            try {
                LOGGER.info("#2 inside method createArchive ==> webXmlGeneratedOnTheFly ==> Creating scatteredArchive [target/webapp]");
                this.warArchive = new ScatteredArchive(this.baseUri.getRawPath(), ScatteredArchive.Type.WAR);
                try {
                    this.warArchive.addMetadata(new File("target/webapp/WEB-INF/", "web.xml"));
                }
                catch (IOException ioe) {
                    LOGGER.info("Encountered IOException [" + ioe.getMessage() + "] trying to addMetadata [" + "target/webapp" + "/" + "WEB-INF" + "/" + "web.xml" + "]");
                    throw new TestContainerException((Throwable)ioe);
                }
                try {
                    this.warArchive.addClassPath(new File("target", "classes"));
                }
                catch (IOException ioe) {
                    LOGGER.info("Encountered IOException [" + ioe.getMessage() + "] trying to addClassPath [" + "target" + "/" + "classes" + "]");
                    throw new TestContainerException((Throwable)ioe);
                }
                LOGGER.info("#2 inside method createArchive ==> webXmlGeneratedOnTheFly ==> just created scatteredArchive [target/webapp] using WEB-INF/web.xml from [" + this.warArchive.toString() + "]");
            }
            catch (Exception ex) {
                throw new TestContainerException((Throwable)ex);
            }
        }
    }
}

