[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [OneOf](./index.md)

# OneOf

`data class OneOf<out K : `[`Key`](-key/index.md)`<`[`T`](index.md#T)`>, T>`

A oneof's value and the key that identifies which field holds it.

Wire has two different mechanisms for generating `oneof` code: “boxed” that uses this class,
and “flat” where all oneof fields are defined inline in the declaring message.

Flat oneofs

This is Wire's default mechanism. Each oneof field in the schema yields a field in the generated
Kotlin or Java class. At most one field has a non-null value, and callers need to manually probe
each field until they find the non-null value.

This is well-suited to oneofs with a small number of choices (less than 5).

Boxed oneofs

In this mechanism the generated class has one field that holds an instance of this. It has both
a key that identifies which field is populated, and its value. If no field is set, then the
OneOf box is null.

This is well-suited to oneofs with a large number of choices (5 or more). This mechanism is
necessary for oneofs with a very large number of options because in the other form the
generated code may exceed the JVM's method size limits.

Opt-in to boxed oneofs in your build by setting the `boxOneOfsMinSize` option. OneOfs with this
many fields or more will be generated in this form.

```
wire {
  kotlin {
    boxOneOfsMinSize = 10
  }
}
```

Using Boxed oneofs

One challenge in using oneofs is coping with data from different schema versions that offer
new unknown choices. For example, a client may receive a message from a server that sets a
oneof field the client doesn't know about; or a server may read an archived message with a
oneof field that has since been deleted.

In either case, the oneof will be null! There is no way to differentiate between unset and set
to an unknown field. Please keep this in mind when writing code to handle oneofs.

In this example the address type may be absent (no value was ever set) or its type may be too
new for the current code to understand. This code returns a default value:

```
val buttonLabel = when (contact.address?.key) {
  Contact.addressSmsNumber -> "Send SMS"
  Contact.addressEmailAddress -> "Send Email"
  else -> "Address Type Unknown or Unset"
}
```

Another approach is to crash. In this case applications need to be careful to avoid receiving
data with an incompatible schema.

```
val buttonLabel = when (contact.address?.key) {
  Contact.addressSmsNumber -> "Send SMS"
  Contact.addressEmailAddress -> "Send Email"
  else -> throw IllegalStateException("unknown address!")
}
```

Consider AnyMessage

New schemas should consider [google.protobuf.Any](../-any-message/index.md) instead of `oneof`.

Benefits of `Any`:

* No build-time dependency from the referencing type on the referenced type.
* Add new types without changing the schema

Benefits of `OneOf`:

* More compact on-the-wire encoding. Approximately 1 byte of overhead for `OneOf` vs. `32` for
    the message name in an `Any`.
* All choices are cataloged a central place in the schema.

### Types

| Name | Summary |
|---|---|
| [Key](-key/index.md) | `abstract class Key<T>`<br>Identifies a field in a OneOf. Typically subclasses are generated by the Wire compiler and instances are declared as members of the referencing message class. |

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `OneOf(key: `[`K`](index.md#K)`, value: `[`T`](index.md#T)`)`<br>A oneof's value and the key that identifies which field holds it. |

### Properties

| Name | Summary |
|---|---|
| [key](key.md) | `val key: `[`K`](index.md#K) |
| [value](value.md) | `val value: `[`T`](index.md#T) |

### Functions

| Name | Summary |
|---|---|
| [encodeWithTag](encode-with-tag.md) | `fun encodeWithTag(writer: `[`ProtoWriter`](../-proto-writer/index.md)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [encodedSizeWithTag](encoded-size-with-tag.md) | `fun encodedSizeWithTag(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [getOrNull](get-or-null.md) | `fun <X> getOrNull(key: `[`Key`](-key/index.md)`<`[`X`](get-or-null.md#X)`>): `[`X`](get-or-null.md#X)`?` |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
