[wire-runtime](../../../index.md) / [com.squareup.wire](../../index.md) / [OneOf](../index.md) / [Key](./index.md)

# Key

`abstract class Key<T>`

Identifies a field in a OneOf. Typically subclasses are generated by the Wire compiler and
instances are declared as members of the referencing message class.

Note that the field's type may not uniquely identify the field. For example:

```
message ContactAddress {
  string name = 1;

  oneof address {
    string sms_number = 2;
    string email_address = 3;
  }
}
```

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Key(tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, adapter: `[`ProtoAdapter`](../../-proto-adapter/index.md)`<`[`T`](index.md#T)`>, declaredName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, redacted: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)` = false, jsonName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = "")`<br>Identifies a field in a OneOf. Typically subclasses are generated by the Wire compiler and instances are declared as members of the referencing message class. |

### Properties

| Name | Summary |
|---|---|
| [adapter](adapter.md) | `val adapter: `[`ProtoAdapter`](../../-proto-adapter/index.md)`<`[`T`](index.md#T)`>` |
| [declaredName](declared-name.md) | `val declaredName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [jsonName](json-name.md) | `val jsonName: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [redacted](redacted.md) | `val redacted: `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [tag](tag.md) | `val tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
