[wire-runtime](../../../index.md) / [com.squareup.wire](../../index.md) / [Message](../index.md) / [Builder](./index.md)

# Builder

`abstract class Builder<M : `[`Message`](../index.md)`<`[`M`](index.md#M)`, `[`B`](index.md#B)`>, B : `[`Builder`](./index.md)`<`[`M`](index.md#M)`, `[`B`](index.md#B)`>>`

**Platform and version requirements:** JVM, native

Superclass for protocol buffer message builders.

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `Builder()`<br>Superclass for protocol buffer message builders. |

### Functions

| Name | Summary |
|---|---|
| [addUnknownField](add-unknown-field.md)<br>(JVM) | `fun addUnknownField(tag: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)`, fieldEncoding: <ERROR CLASS>, value: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Builder`](./index.md)`<`[`M`](index.md#M)`, `[`B`](index.md#B)`>` |
| [addUnknownFields](add-unknown-fields.md)<br>(JVM) | `fun addUnknownFields(unknownFields: <ERROR CLASS>): `[`Builder`](./index.md)`<`[`M`](index.md#M)`, `[`B`](index.md#B)`>` |
| [build](build.md)<br>(JVM) | `abstract fun build(): `[`M`](index.md#M)<br>Returns an immutable [Message](../index.md) based on the fields that set in this builder. |
| [buildUnknownFields](build-unknown-fields.md)<br>(JVM) | `fun buildUnknownFields(): <ERROR CLASS>`<br>Returns a byte string with this message's unknown fields. Returns an empty byte string if this message has no unknown fields. |
| [clearUnknownFields](clear-unknown-fields.md)<br>(JVM) | `fun clearUnknownFields(): `[`Builder`](./index.md)`<`[`M`](index.md#M)`, `[`B`](index.md#B)`>` |
