[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [MessageSource](./index.md)

# MessageSource

`expect interface MessageSource<out T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

**Platform and version requirements:** JVM, native

A readable stream of messages.

Typical implementations will receive messages recently transmitted from a peer, such as for
server-to-client or client-to-server networking. But this implementation is not limited to such
networking use cases and implementations may load messages from local storage or generate
messages on demand.

Calls to [read](read.md) will block until a message becomes available. There is no mechanism to limit how
long a specific [read](read.md) will wait, though implementations may be configured to fail if they
consider a source to be unhealthy.

Readers should take care to keep up with the stream of messages. A reader that takes an excessive
amount of time to process a message may cause their writer to back up and suffer queueing.

Instances of this interface are not safe for concurrent use.

### Functions

| Name | Summary |
|---|---|
| [close](close.md) | `abstract fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) |
| [read](read.md) | `abstract fun read(): `[`T`](index.md#T)`?`<br>Read the next length-prefixed message on the stream and return it. Returns null if there are no further messages on this stream. |
