[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [MessageSink](./index.md)

# MessageSink

`expect interface MessageSink<in T : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`>`

**Platform and version requirements:** JVM, native

A writable stream of messages.

Typical implementations will immediately encode messages and enqueue them for transmission, such
as for client-to-server or server-to-client networking. But this interface is not limited to 1-1
networking use cases and implementations may persist, broadcast, validate, or take any other
action with the messages.

There is no flushing mechanism. Messages are flushed one-by-one as they are written. This
minimizes latency at a potential cost of throughput.

On its own this offers no guarantees that messages are delivered. For example, a message may
accepted by [write](write.md) could be lost due to a network partition or crash. It is the caller's
responsibility to confirm delivery and to retransmit as necessary.

It is possible for a writer to saturate the transmission channel, such as when a writer writes
faster than the corresponding reader can read. In such cases calls to [write](write.md) will block until
there is capacity in the outbound channel. You may use this as a basic backpressure mechanism.
You should ensure that such backpressure propagates to the originator of outbound messages.

Instances of this interface are not safe for concurrent use.

### Functions

| Name | Summary |
|---|---|
| [cancel](cancel.md) | `abstract fun cancel(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Truncate this stream abnormally. This attempts to signal to readers of this data that it is incomplete. Note that unlike some cancel methods this is not safe for concurrent use. |
| [close](close.md) | `abstract fun close(): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Terminate the stream and release its resources. If this has not been canceled this signals a normal completion of the stream. |
| [write](write.md) | `abstract fun write(message: `[`T`](index.md#T)`): `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)<br>Encode [message](write.md#com.squareup.wire.MessageSink$write(com.squareup.wire.MessageSink.T)/message) to bytes and enqueue the bytes for delivery, waiting if necessary until the delivery channel has capacity for the encoded message. |
