[wire-runtime](../../index.md) / [com.squareup.wire](../index.md) / [AnyMessage](./index.md)

# AnyMessage

`class AnyMessage : `[`Message`](../-message/index.md)`<`[`AnyMessage`](./index.md)`, `[`Nothing`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-nothing/index.html)`>`

Wire implementation of the `google.protobuf.Any` type. The `Any` type wraps an arbitrary
protobuf message. Field of `Any` generated by Wire will be typed [AnyMessage](./index.md). [typeUrl](type-url.md) is
used to identify the type of the message, defined as 'type.googleapis.com/full.type.name'.
[value](value.md) is the serialized representation of the wrapped message. The [pack](pack.md) and [unpack](unpack.md) methods
are available to wrap and unwrap an `Any` message.

Example

```
val person: Person = anyMessage.unpack(Person.ADAPTER)
val anyMessage: AnyMessage = AnyMessage.ADAPTER.pack(person)
```

### Constructors

| Name | Summary |
|---|---|
| [&lt;init&gt;](-init-.md) | `AnyMessage(typeUrl: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)`, value: <ERROR CLASS> = ByteString.EMPTY)`<br>Wire implementation of the `google.protobuf.Any` type. The `Any` type wraps an arbitrary protobuf message. Field of `Any` generated by Wire will be typed [AnyMessage](./index.md). [typeUrl](type-url.md) is used to identify the type of the message, defined as 'type.googleapis.com/full.type.name'. [value](value.md) is the serialized representation of the wrapped message. The [pack](pack.md) and [unpack](unpack.md) methods are available to wrap and unwrap an `Any` message. |

### Properties

| Name | Summary |
|---|---|
| [typeUrl](type-url.md) | `val typeUrl: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [value](value.md) | `val value: <ERROR CLASS>` |

### Inherited Properties

| Name | Summary |
|---|---|
| [adapter](../-message/adapter.md)<br>(JVM, native) | `val adapter: `[`ProtoAdapter`](../-proto-adapter/index.md)`<`[`M`](../-message/index.md#M)`>`<br>The [ProtoAdapter](../-proto-adapter/index.md) for encoding and decoding messages of this type. |
| [hashCode](../-message/hash-code.md)<br>(JVM, native) | `var hashCode: `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)<br>If non-zero, the hash code of this message. Accessed by generated code. |
| [unknownFields](../-message/unknown-fields.md)<br>(JVM, native) | `val unknownFields: <ERROR CLASS>`<br>Returns a byte string containing the proto encoding of this message's unknown fields. Returns an empty byte string if this message has no unknown fields. |

### Functions

| Name | Summary |
|---|---|
| [copy](copy.md) | `fun copy(typeUrl: `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)` = this.typeUrl, value: <ERROR CLASS> = this.value): `[`AnyMessage`](./index.md) |
| [equals](equals.md) | `fun equals(other: `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`?): `[`Boolean`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [hashCode](hash-code.md) | `fun hashCode(): `[`Int`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [toString](to-string.md) | `fun toString(): `[`String`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [unpack](unpack.md) | `fun <T> unpack(adapter: `[`ProtoAdapter`](../-proto-adapter/index.md)`<`[`T`](unpack.md#T)`>): `[`T`](unpack.md#T) |
| [unpackOrNull](unpack-or-null.md) | `fun <T> unpackOrNull(adapter: `[`ProtoAdapter`](../-proto-adapter/index.md)`<`[`T`](unpack-or-null.md#T)`>): `[`T`](unpack-or-null.md#T)`?` |

### Inherited Functions

| Name | Summary |
|---|---|
| [encode](../-message/encode.md)<br>(JVM, native) | `fun encode(): `[`ByteArray`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-byte-array/index.html)<br>Encode this message as a `byte[]`. |
| [encodeByteString](../-message/encode-byte-string.md)<br>(JVM, native) | `fun encodeByteString(): <ERROR CLASS>`<br>Encode this message as a `ByteString`. |

### Companion Object Properties

| Name | Summary |
|---|---|
| [ADAPTER](-a-d-a-p-t-e-r.md) | `val ADAPTER: `[`ProtoAdapter`](../-proto-adapter/index.md)`<`[`AnyMessage`](./index.md)`>` |

### Companion Object Functions

| Name | Summary |
|---|---|
| [pack](pack.md) | `fun pack(message: `[`Message`](../-message/index.md)`<*, *>): `[`AnyMessage`](./index.md) |
