[wire-grpc-client](../index.md) / [com.squareup.wire](index.md) / [GrpcStreamingCall](./-grpc-streaming-call.md)

# GrpcStreamingCall

`fun <S : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`, R : `[`Any`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)`> GrpcStreamingCall(function: suspend (<ERROR CLASS><`[`S`](-grpc-streaming-call.md#S)`>, <ERROR CLASS><`[`R`](-grpc-streaming-call.md#R)`>) -> `[`Unit`](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)`): <ERROR CLASS><`[`S`](-grpc-streaming-call.md#S)`, `[`R`](-grpc-streaming-call.md#R)`>`

**Platform and version requirements:** JVM

Returns a new instance of [GrpcStreamingCall](./-grpc-streaming-call.md) that can be used for a single call to
[executeIn](#) or [executeBlocking](#).

The returned instance launches [function](-grpc-streaming-call.md#com.squareup.wire$GrpcStreamingCall(kotlin.SuspendFunction2((((com.squareup.wire.GrpcStreamingCall.S)), ((com.squareup.wire.GrpcStreamingCall.R)), kotlin.Unit)))/function) on [Dispatchers.IO](#). The function must close the
[SendChannel](#) when it has no more messages to transmit. If [function](-grpc-streaming-call.md#com.squareup.wire$GrpcStreamingCall(kotlin.SuspendFunction2((((com.squareup.wire.GrpcStreamingCall.S)), ((com.squareup.wire.GrpcStreamingCall.R)), kotlin.Unit)))/function) throws, both channels will
be closed using the thrown exception as a cause.

This method is useful when implementing the interfaces that are generated by Wire:

```
override fun RouteChat(): GrpcStreamingCall<RouteNote, RouteNote> {
  return GrpcStreamingCall { requests, responses ->
    requests.consumeEach { note ->
      responses.send(translateNote(note))
    }
    responses.close()
  }
}
```

It is succinct when used in an expression function:

```
override fun RouteChat() = GrpcStreamingCall<RouteNote, RouteNote> { requests, responses ->
  requests.consumeEach { note ->
    responses.send(translateNote(note))
  }
  responses.close()
}
```

