//[wire-compiler](../../index.md)/[com.squareup.wire.schema](index.md)

# Package com.squareup.wire.schema

## Types

| Name | Summary |
|---|---|
| [CustomHandlerBeta](-custom-handler-beta/index.md) | [jvm]<br>interface [CustomHandlerBeta](-custom-handler-beta/index.md)<br>Implementations of this interface must have a no-arguments public constructor. |
| [CustomTargetBeta](-custom-target-beta/index.md) | [jvm]<br>data class [CustomTargetBeta](-custom-target-beta/index.md)(includes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, excludes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, exclusive: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), outDirectory: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), customHandler: [CustomHandlerBeta](-custom-handler-beta/index.md)) : [Target](-target/index.md)<br>Generate something custom defined by an external class. |
| [JavaTarget](-java-target/index.md) | [jvm]<br>data class [JavaTarget](-java-target/index.md)(includes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, excludes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, exclusive: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), outDirectory: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), android: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), androidAnnotations: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), compact: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), emitDeclaredOptions: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), emitAppliedOptions: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)) : [Target](-target/index.md)<br>Generate .java sources. |
| [KotlinTarget](-kotlin-target/index.md) | [jvm]<br>data class [KotlinTarget](-kotlin-target/index.md)(includes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, excludes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, exclusive: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), outDirectory: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), android: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), javaInterop: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), emitDeclaredOptions: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), emitAppliedOptions: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), rpcCallStyle: RpcCallStyle, rpcRole: RpcRole, singleMethodServices: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), boxOneOfsMinSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), grpcServerCompatible: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), nameSuffix: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?) : [Target](-target/index.md)<br>Generate .kt sources. |
| [NullTarget](-null-target/index.md) | [jvm]<br>data class [NullTarget](-null-target/index.md)(includes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, excludes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;) : [Target](-target/index.md)<br>Omit code generation for these sources. Use this for a dry-run. |
| [ProfileLoader](-profile-loader/index.md) | [jvm]<br>interface [ProfileLoader](-profile-loader/index.md) |
| [ProtoTarget](-proto-target/index.md) | [jvm]<br>data class [ProtoTarget](-proto-target/index.md)(outDirectory: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : [Target](-target/index.md) |
| [SchemaLoader](-schema-loader/index.md) | [jvm]<br>class [SchemaLoader](-schema-loader/index.md) : [Closeable](https://docs.oracle.com/javase/8/docs/api/java/io/Closeable.html), Loader, [ProfileLoader](-profile-loader/index.md)<br>Load proto files and their transitive dependencies and parse them. Keep track of which files were loaded from where so that we can use that information later when deciding what to generate. |
| [SwiftTarget](-swift-target/index.md) | [jvm]<br>data class [SwiftTarget](-swift-target/index.md)(includes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, excludes: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, exclusive: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html), outDirectory: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : [Target](-target/index.md) |
| [Target](-target/index.md) | [jvm]<br>sealed class [Target](-target/index.md) : [Serializable](https://docs.oracle.com/javase/8/docs/api/java/io/Serializable.html) |
| [WireRun](-wire-run/index.md) | [jvm]<br>data class [WireRun](-wire-run/index.md)(sourcePath: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Location&gt;, protoPath: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;Location&gt;, treeShakingRoots: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, treeShakingRubbish: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)&gt;, moves: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;TypeMover.Move&gt;, sinceVersion: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, untilVersion: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, onlyVersion: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, targets: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Target](-target/index.md)&gt;, modules: [Map](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-map/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), [WireRun.Module](-wire-run/-module/index.md)&gt;, permitPackageCycles: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html))<br>An invocation of the Wire compiler. Each invocation performs the following operations: |

## Functions

| Name | Summary |
|---|---|
| [newCustomHandler](new-custom-handler.md) | [jvm]<br>fun [newCustomHandler](new-custom-handler.md)(customHandlerClass: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)): [CustomHandlerBeta](-custom-handler-beta/index.md)<br>Create and return an instance of [customHandlerClass](new-custom-handler.md). |
