//[wire-schema](../../index.md)/[com.squareup.wire.schema.internal](index.md)

# Package com.squareup.wire.schema.internal

## Types

| Name | Summary |
|---|---|
| [DagChecker](-dag-checker/index.md) | [common]<br>class [DagChecker](-dag-checker/index.md)&lt;[N](-dag-checker/index.md)&gt;(nodes: [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[N](-dag-checker/index.md)&gt;, edges: ([N](-dag-checker/index.md)) -&gt; [Iterable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-iterable/index.html)&lt;[N](-dag-checker/index.md)&gt;)<br>Checks whether a graph is a directed acyclic graph using [Tarjan's algorithm](https://en.wikipedia.org/wiki/Tarjan%27s_strongly_connected_components_algorithm). |
| [MutableQueue](-mutable-queue/index.md) | [common, js, jvm]<br>[common, js]<br>interface [MutableQueue](-mutable-queue/index.md)&lt;[T](-mutable-queue/index.md) : [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt; : [MutableCollection](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-mutable-collection/index.html)&lt;[T](-mutable-queue/index.md)&gt; <br>[jvm]<br>typealias [MutableQueue](-mutable-queue/index.md) = [Queue](https://docs.oracle.com/javase/8/docs/api/java/util/Queue.html)&lt;[T](-mutable-queue/index.md)&gt; |
| [SchemaEncoder](-schema-encoder/index.md) | [common]<br>class [SchemaEncoder](-schema-encoder/index.md)(schema: [Schema](../com.squareup.wire.schema/-schema/index.md))<br>This class encodes files from a Wire schema using the types in protobuf's descriptor.proto. Unfortunately, the two models don't line up directly: |
| [TypeMover](-type-mover/index.md) | [common]<br>class [TypeMover](-type-mover/index.md)(oldSchema: [Schema](../com.squareup.wire.schema/-schema/index.md), moves: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[TypeMover.Move](-type-mover/-move/index.md)&gt;)<br>Refactor a schema by moving a proto type declaration. |

## Functions

| Name | Summary |
|---|---|
| [annotationTargetType](annotation-target-type.md) | [jvm]<br>fun [annotationTargetType](annotation-target-type.md)(extend: Extend): [ElementType](https://docs.oracle.com/javase/8/docs/api/java/lang/annotation/ElementType.html)? |
| [appendDocumentation](append-documentation.md) | [common]<br>fun [StringBuilder](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.text/-string-builder/index.html).[appendDocumentation](append-documentation.md)(documentation: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) |
| [appendIndented](append-indented.md) | [common]<br>fun [StringBuilder](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.text/-string-builder/index.html).[appendIndented](append-indented.md)(value: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) |
| [builtInAdapterString](built-in-adapter-string.md) | [jvm]<br>fun [builtInAdapterString](built-in-adapter-string.md)(type: ProtoType): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? |
| [eligibleAsAnnotationMember](eligible-as-annotation-member.md) | [jvm]<br>fun [eligibleAsAnnotationMember](eligible-as-annotation-member.md)(schema: Schema, field: Field): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [javaPackage](java-package.md) | [jvm]<br>fun [javaPackage](java-package.md)(protoFile: ProtoFile): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
| [optionValueToInt](option-value-to-int.md) | [jvm]<br>fun [optionValueToInt](option-value-to-int.md)(value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) |
| [optionValueToLong](option-value-to-long.md) | [jvm]<br>fun [optionValueToLong](option-value-to-long.md)(value: [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?): [Long](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-long/index.html) |
| [withStubs](with-stubs.md) | [common]<br>fun [Schema](../com.squareup.wire.schema/-schema/index.md).[withStubs](with-stubs.md)(typesToStub: [Set](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-set/index.html)&lt;[ProtoType](../com.squareup.wire.schema/-proto-type/index.md)&gt;): [Schema](../com.squareup.wire.schema/-schema/index.md)<br>Replace types in this schema which are present in [typesToStub](with-stubs.md) with empty shells that have no outward references. This has to be done in this module so that we can access the internal constructor to avoid re-linking. |
